<?php
$options = manzil_WSH()->option(); 
$allowed_html = wp_kses_allowed_html( 'post' );

$image_logo = $options->get( 'image_normal_logo' );
$logo_dimension = $options->get( 'normal_logo_dimension' );

$image_logo2 = $options->get( 'image_normal_logo2' );
$logo_dimension2 = $options->get( 'normal_logo_dimension2' );

$logo_type = '';
$logo_text = '';
$logo_typography = '';
?>

    <!-- Main Header -->
    <header class="main-header header-style-one">
    	<?php if( $options->get('welcome_text') ):?>
        <!--Header Top-->
        <div class="header-top">
            <div class="auto-container">
                <div class="clearfix">
                    <!--Top Left-->
                    <div class="top-left clearfix">
						<div class="text"><?php echo wp_kses($options->get('welcome_text'), $allowed_html);?> </div>
                    </div>
                </div>
            </div>
        </div>
    	<?php endif; ?>
        <!--Header-Upper-->
        <div class="header-upper">
            <div class="auto-container">
                <div class="clearfix">
                    
                    <div class="pull-right upper-right clearfix">
                        <?php if( $options->get('address_v1') ):?>
                        <!--Info Box-->
                        <div class="upper-column info-box">
                            <div class="icon-box"><span class="flaticon-world"></span></div>
                            <ul>
                                <?php echo wp_kses($options->get('address_v1'), $allowed_html);?>
                            </ul>
                        </div>
                        <?php endif; ?>
						<?php if( $options->get('email_address_v1') ):?>
                        <!--Info Box-->
                        <div class="upper-column info-box">
                            <div class="icon-box"><span class="flaticon-email-3"></span></div>
                            <ul>
                                <?php echo wp_kses($options->get('email_address_v1'), $allowed_html);?>
                            </ul>
                        </div>
                        <?php endif; ?>
                        <?php if( $options->get('working_hours_v1') ):?>
                        <!--Info Box-->
                        <div class="upper-column info-box">
                            <div class="icon-box"><span class="flaticon-clock-3"></span></div>
                            <ul>
								<?php echo wp_kses($options->get('working_hours_v1'), $allowed_html);?>
                            </ul>
                        </div>
                        <?php endif; ?>
                    </div>
                    
                </div>
            </div>
        </div>
        <!--End Header Upper-->
        
        <!--Header Lower-->
        <div class="header-lower">
            
            <div class="auto-container">
				<div class="clearfix">

					<!-- Logo Box -->
					<div class="pull-left logo-box">
						<div class="logo">
                        	<?php echo manzil_logo( $logo_type, $image_logo, $logo_dimension, $logo_text, $logo_typography ); ?>
                        </div>
					</div>
				
					<div class="nav-outer clearfix">
						<!-- Mobile Navigation Toggler -->
						<div class="mobile-nav-toggler"><span class="icon flaticon-menu-2"></span></div>
						<!-- Main Menu -->
						<nav class="main-menu show navbar-expand-md">
							<div class="navbar-header">
								<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
									<span class="icon-bar"></span>
									<span class="icon-bar"></span>
									<span class="icon-bar"></span>
								</button>
							</div>
							
							<div class="navbar-collapse collapse clearfix" id="navbarSupportedContent">
								<ul class="navigation clearfix">
									<?php wp_nav_menu( array( 'theme_location' => 'main_menu', 'container_id' => 'navbar-collapse-1',
                                        'container_class'=>'navbar-collapse collapse navbar-right',
                                        'menu_class'=>'nav navbar-nav',
                                        'fallback_cb'=>false, 
                                        'items_wrap' => '%3$s', 
                                        'container'=>false,
                                        'depth'=>'3',
                                        'walker'=> new Bootstrap_walker()  
                                    ) ); ?>
								</ul>
							</div>
						</nav>
						<!-- Main Menu End-->

						<!-- Options Box -->
						<div class="options-box clearfix">
							<?php if( $options->get('search_form_icon_v1') ):?>
							<!--Search Box-->
							<div class="search-box-outer">
								<div class="search-box-btn"><span class="fa fa-search"></span></div>
							</div>
                            <?php endif; ?>
							<?php if( $options->get('btn_title_v1') ):?>
							<div class="btn-box">
								<a href="<?php echo esc_url($options->get('btn_link_v1'));?>" class="theme-btn btn-style-one"><span class="txt"><?php echo wp_kses($options->get('btn_title_v1'), $allowed_html);?></span></a>
							</div>
							<?php endif; ?>
						</div>
						
					</div>
				</div>
            </div>
        </div>
        <!-- End Header Lower -->
        
		<!-- Sticky Header  -->
        <div class="sticky-header">
            <div class="auto-container clearfix">
                <!--Logo-->
                <div class="logo pull-left">
                    <?php echo manzil_logo( $logo_type, $image_logo2, $logo_dimension2, $logo_text, $logo_typography ); ?>
                </div>
                <!--Right Col-->
                <div class="pull-right">
                    <!-- Main Menu -->
                    <nav class="main-menu">
                        <!--Keep This Empty / Menu will come through Javascript-->
                    </nav><!-- Main Menu End-->
					
					<!-- Options Box -->
					<div class="options-box clearfix">
						<?php if( $options->get('search_form_icon_v1') ):?>
						<!--Search Box-->
						<div class="search-box-outer">
							<div class="search-box-btn"><span class="fa fa-search"></span></div>
						</div>
						<?php endif; ?>
						<?php if( $options->get('btn_title_v1') ):?>
						<div class="btn-box">
							<a href="<?php echo esc_url($options->get('btn_link_v1'));?>" class="theme-btn btn-style-one"><span class="txt"><?php echo wp_kses($options->get('btn_title_v1'), $allowed_html);?></span></a>
						</div>
						<?php endif; ?>
					</div>
					
                </div>
            </div>
        </div><!-- End Sticky Menu -->
		
        <!-- Mobile Menu  -->
        <div class="mobile-menu">
            <div class="menu-backdrop"></div>
            <div class="close-btn"><span class="icon flaticon-multiply"></span></div>
            
            <nav class="menu-box">
                <div class="nav-logo">
                	<?php echo manzil_logo( $logo_type, $image_logo, $logo_dimension, $logo_text, $logo_typography ); ?>
                </div>
                <div class="menu-outer">
					<!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
				</div>
            </nav>
        </div><!-- End Mobile Menu -->
    
    </header>
    <!-- End Main Header -->