<?php
$options = manzil_WSH()->option();
$allowed_html = wp_kses_allowed_html( 'post' );

$image_logo = $options->get( 'image_normal_logo' );
$logo_dimension = $options->get( 'normal_logo_dimension' );

$image_logo2 = $options->get( 'image_normal_logo2' );
$logo_dimension2 = $options->get( 'normal_logo_dimension2' );

$image_logo3 = $options->get( 'image_normal_logo3' );
$logo_dimension3 = $options->get( 'normal_logo_dimension3' );

$logo_type = '';
$logo_text = '';
$logo_typography = '';
?>

	<!-- Main Header / Header Style Three -->
    <header class="main-header header-style-three">
    
        <!-- Header Top Two -->
        <div class="header-top-two style-two">
            <div class="auto-container">
                <div class="inner-container clearfix">
                    <!-- Top Left -->
                    <div class="top-left clearfix">
						<ul class="top-list">
							<?php if( $options->get('address_v3') ):?><li><span class="icon flaticon-maps-and-flags"></span><?php echo wp_kses($options->get('address_v3'), $allowed_html);?></li><?php endif; ?>
							<?php if( $options->get('phone_no_v3') ):?><li><span class="icon flaticon-telephone"></span><a href="tel:<?php echo esc_url($options->get('phone_no_v3'));?>"><?php echo wp_kses($options->get('phone_no_v3'), $allowed_html);?></a></li><?php endif; ?>
						</ul>
                    </div>
					<?php
						$icons = $options->get( 'header_v3_social_share' );
						if ( ! empty( $icons ) ) :
					?>
					<!-- Top Right -->
                    <div class="top-right clearfix">
						<!-- Social Box -->
						<ul class="social-box">
						<?php
							foreach ( $icons as $h_icon ) :
							$header_social_icons = json_decode( urldecode( manzil_set( $h_icon, 'data' ) ) );
							if ( manzil_set( $header_social_icons, 'enable' ) == '' ) {
								continue;
							}
							$icon_class = explode( '-', manzil_set( $header_social_icons, 'icon' ) );
							?>
							<li><a href="<?php echo esc_url(manzil_set( $header_social_icons, 'url' )); ?>" style="background-color:<?php echo esc_attr(manzil_set( $header_social_icons, 'background' )); ?>; color: <?php echo esc_attr(manzil_set( $header_social_icons, 'color' )); ?>" class="fa <?php echo esc_attr( manzil_set( $header_social_icons, 'icon' ) ); ?>"></a></li>
						<?php endforeach; ?>
						</ul>
					</div>
					<?php endif; ?>
                </div>
            </div>
        </div>
		
        <!--Header Lower-->
        <div class="header-lower">
            
            <div class="auto-container">
				<div class="clearfix">

					<!-- Logo Box -->
					<div class="pull-left logo-box">
						<div class="logo">
                        	<?php echo manzil_logo( $logo_type, $image_logo3, $logo_dimension3, $logo_text, $logo_typography ); ?>
                        </div>
					</div>
				
					<div class="nav-outer clearfix">
						<!-- Mobile Navigation Toggler -->
						<div class="mobile-nav-toggler"><span class="icon flaticon-menu-2"></span></div>
						<!-- Main Menu -->
						<nav class="main-menu show navbar-expand-md">
							<div class="navbar-header">
								<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
									<span class="icon-bar"></span>
									<span class="icon-bar"></span>
									<span class="icon-bar"></span>
								</button>
							</div>
							
							<div class="navbar-collapse collapse clearfix" id="navbarSupportedContent">
								<ul class="navigation clearfix">
									<?php wp_nav_menu( array( 'theme_location' => 'main_menu', 'container_id' => 'navbar-collapse-1',
                                        'container_class'=>'navbar-collapse collapse navbar-right',
                                        'menu_class'=>'nav navbar-nav',
                                        'fallback_cb'=>false, 
                                        'items_wrap' => '%3$s', 
                                        'container'=>false,
                                        'depth'=>'3',
                                        'walker'=> new Bootstrap_walker()  
                                    ) ); ?>
								</ul>
							</div>
						</nav>
						<!-- Main Menu End-->

						<!-- Options Box -->
						<div class="options-box clearfix">
							<?php if( $options->get('shopping_cart_icon_v3') ):?>
                            <?php if( function_exists( 'WC' ) ): global $woocommerce; ?>
							<!-- Cart Box -->
							<div class="cart-box">
								<div class="dropdown">
									<button class="cart-box-btn dropdown-toggle" type="button" id="dropdownMenu" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><span class="flaticon-shopping-bag-1"></span><span class="total-cart"><?php echo wp_kses( $woocommerce->cart->cart_contents_count, $allowed_html )?></span></button>
									<div class="dropdown-menu pull-right cart-panel">
										<?php get_template_part('templates/widgets/cart_items'); ?>

										<?php if (WC()->cart->get_cart()): ?>
                                        
                                        <div class="cart-total"><?php esc_html_e('Sub Total: ', 'manzil'); ?><span><?php echo wp_kses_post($woocommerce->cart->get_cart_total()); ?></span></div>
                                        <ul class="btns-boxed">
                                            <?php
                                                $cart_url = wc_get_cart_url();
                                                if ($cart_url) :
                                            ?>
                                            <li><a href="<?php echo esc_url($cart_url); ?>"><?php esc_html_e('View Cart', 'manzil'); ?></a></li>
                                            <?php endif; ?>
                                            <?php
                                                $checkout_url = wc_get_checkout_url();
                                                if ($checkout_url) :
                                            ?>
                                            <li><a href="<?php echo esc_url($checkout_url); ?>"><?php esc_html_e('Checkout', 'manzil'); ?></a></li>
                                            <?php endif; ?>
                                        </ul>
                                    	<?php endif; ?>
									</div>
								</div>
							</div>
                            <?php endif; ?>
                            <?php endif; ?>
							<?php if( $options->get('search_form_icon_v3') ):?>
							<!--Search Box-->
							<div class="search-box-outer">
								<div class="search-box-btn"><span class="fa fa-search"></span></div>
							</div>
							<?php endif; ?>
							<?php if( $options->get('btn_title_v3') ):?>
							<div class="btn-box">
								<a href="<?php echo esc_url($options->get('btn_link_v3'));?>" class="theme-btn btn-style-three"><span class="txt"><?php echo wp_kses($options->get('btn_title_v3'), $allowed_html);?></span></a>
							</div>
							<?php endif; ?>
						</div>
						
					</div>
				</div>
            </div>
        </div>
        <!-- End Header Lower -->
        
		<!-- Sticky Header  -->
        <div class="sticky-header">
            <div class="auto-container clearfix">
                <!--Logo-->
                <div class="logo pull-left">
                    <?php echo manzil_logo( $logo_type, $image_logo2, $logo_dimension2, $logo_text, $logo_typography ); ?>
                </div>
                <!--Right Col-->
                <div class="pull-right">
                    <!-- Main Menu -->
                    <nav class="main-menu">
                        <!--Keep This Empty / Menu will come through Javascript-->
                    </nav><!-- Main Menu End-->
					
					<!-- Options Box -->
					<div class="options-box clearfix">
						<?php if( $options->get('shopping_cart_icon_v3') ):?>
						<?php if( function_exists( 'WC' ) ): global $woocommerce; ?>
                        <!-- Cart Box -->
                        <div class="cart-box">
                            <div class="dropdown">
                                <button class="cart-box-btn dropdown-toggle" type="button" id="dropdownMenu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><span class="flaticon-shopping-bag-1"></span><span class="total-cart"><?php echo wp_kses( $woocommerce->cart->cart_contents_count, $allowed_html )?></span></button>
                                <div class="dropdown-menu pull-right cart-panel">
									<?php get_template_part('templates/widgets/cart_items'); ?>

									<?php if (WC()->cart->get_cart()): ?>
                                    
                                    <div class="cart-total"><?php esc_html_e('Sub Total: ', 'manzil'); ?><span><?php echo wp_kses_post($woocommerce->cart->get_cart_total()); ?></span></div>
                                    <ul class="btns-boxed">
                                        <?php
                                            $cart_url = wc_get_cart_url();
                                            if ($cart_url) :
                                        ?>
                                        <li><a href="<?php echo esc_url($cart_url); ?>"><?php esc_html_e('View Cart', 'manzil'); ?></a></li>
                                        <?php endif; ?>
                                        <?php
                                            $checkout_url = wc_get_checkout_url();
                                            if ($checkout_url) :
                                        ?>
                                        <li><a href="<?php echo esc_url($checkout_url); ?>"><?php esc_html_e('Checkout', 'manzil'); ?></a></li>
                                        <?php endif; ?>
                                    </ul>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
						<?php endif; ?>
                        <?php endif; ?>
						<?php if( $options->get('search_form_icon_v3') ):?>
						<!--Search Box-->
						<div class="search-box-outer">
							<div class="search-box-btn"><span class="fa fa-search"></span></div>
						</div>
						<?php endif; ?>
						<?php if( $options->get('btn_title_v3') ):?>
						<div class="btn-box">
							<a href="<?php echo esc_url($options->get('btn_link_v3'));?>" class="theme-btn btn-style-one"><span class="txt"><?php echo wp_kses($options->get('btn_title_v3'), $allowed_html);?></span></a>
						</div>
						<?php endif; ?>
					</div>
					
                </div>
            </div>
        </div><!-- End Sticky Menu -->
		
        <!-- Mobile Menu  -->
        <div class="mobile-menu">
            <div class="menu-backdrop"></div>
            <div class="close-btn"><span class="icon flaticon-multiply"></span></div>
            
            <nav class="menu-box">
                <div class="nav-logo">
                	<?php echo manzil_logo( $logo_type, $image_logo, $logo_dimension, $logo_text, $logo_typography ); ?>
                </div>
                <div class="menu-outer">
					<!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
				</div>
            </nav>
        </div><!-- End Mobile Menu -->
    
    </header>
    <!-- End Main Header -->