<?php

namespace MANZILPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class About_Us_V2 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'manzil_about_us_v2';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'About us V2', 'manzil' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fa fa-briefcase';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'manzil' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'about_us_v2',
			[
				'label' => esc_html__( 'About Us V2', 'manzil' ),
			]
		);
		$this->add_control(
			'pattern_image',
				[
				  'label' => __( 'Background Pattern Image', 'manzil' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				  
				]
	    );
		$this->add_control(
			'bg_img',
				[
				  'label' => __( 'Background Image', 'manzil' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				  
				]
	    );
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'manzil' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'manzil' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'manzil' ),
			]
		);
		$this->add_control(
			'title1',
			[
				'label'       => __( 'Sub Heading', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Heading', 'manzil' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text', 'manzil' ),
			]
		);
		$this->add_control(
			'btn_title',
			[
				'label'       => __( 'Button Title', 'manzil' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Button Title', 'manzil' ),
				'default'     => __( 'Read More', 'manzil' ),
			]
		);
		$this->add_control(
			'btn_link',
				[
				  'label' => __( 'Button Url', 'manzil' ),
				  'type' => Controls_Manager::URL,
				  'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				  'show_external' => true,
				  'default' => [
				    'url' => '',
				    'is_external' => true,
				    'nofollow' => true,
				  ],
				
			   ]
		);
		$this->add_control(
			'about_image',
				[
				  'label' => __( 'About Image', 'manzil' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				  
				]
	    );
		$this->add_control(
            'style_two',
			[
				'label'   => esc_html__( 'Choose Spacing Style', 'manzil' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'one',
				'options' => array(
					'one' => esc_html__( 'Choose Spacing Style One', 'manzil' ),
					'two'  => esc_html__( 'Choose Spacing Style Two', 'manzil' ),
				),
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>
        
        <!-- About Section Two -->
        <section class="about-section-two <?php if($settings['style_two'] == 'two') echo 'style-two'; else echo '' ;?>">
            <div class="pattern-layer" style="background-image:url(<?php echo esc_url($settings['pattern_image']['url']);?>)"></div>
            <div class="image-layer" style="background-image:url(<?php echo esc_url($settings['bg_img']['url']);?>)"></div>
            <div class="auto-container">
                <!-- Sec Title -->
                <div class="sec-title centered">
                    <div class="title">
                        <!-- Title Effect -->
                        <div class="title-effect">
                            <div class="bar bar-top"></div>
                            <div class="bar bar-right"></div>
                            <div class="bar bar-bottom"></div>
                            <div class="bar bar-left"></div>
                        </div>
                        <?php echo wp_kses( $settings['subtitle'], $allowed_tags );?>
                    </div>
                    <h2><?php echo wp_kses( $settings['title'], $allowed_tags );?></h2>
                </div>
                
                <div class="row clearfix">
                    
                    <!-- Content Column -->
                    <div class="content-column col-lg-4 col-md-12 col-sm-12">
                        <div class="inner-column wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <h3><a href="<?php echo esc_url($settings['btn_link']['url']);?>"><?php echo wp_kses( $settings['title1'], $allowed_tags );?></a></h3>
                            <div class="text"><?php echo wp_kses( $settings['text'], $allowed_tags );?></div>
                            <a href="<?php echo esc_url($settings['btn_link']['url']);?>" class="read-more theme-btn"><?php echo wp_kses($settings['btn_title'], $allowed_tags); ?></a>
                        </div>
                    </div>
                    
                    <!-- Image Column -->
                    <div class="image-column col-lg-8 col-md-12 col-sm-12">
                        <div class="inner-column wow fadeInRight" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <div class="image">
                                <img src="<?php echo $settings['about_image']['url'];?>" alt="<?php esc_attr_e('Awesome Image', 'manzil'); ?>" />
                            </div>
                        </div>
                    </div>
                    
                </div>
                
            </div>
        </section>
        <!-- End About Section Two -->
         
		<?php 
	}

}
