<?php

namespace MANZILPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Comming_Soon extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'manzil_comming_soon';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Comming Soon', 'manzil' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fa fa-briefcase';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'manzil' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'comming_soon',
			[
				'label' => esc_html__( 'Comming Soon', 'manzil' ),
			]
		);
		$this->add_control(
			'bg_img',
				[
				  'label' => __( 'Background Image', 'manzil' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				  
				]
	    );
		$this->add_control(
			'logo_img',
				[
				  'label' => __( 'Logo Image', 'manzil' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				  
				]
	    );
		$this->add_control(
			'counter_value',
			[
				'label'       => __( 'Counter Value', 'manzil' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Counter Value', 'manzil' ),
				'default' => esc_html__('201/10/1', 'manzil'),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'manzil' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text', 'manzil' ),
			]
		);
		$this->add_control(
			'form_id',
			[
				'label'       => __( 'FeedBurner ID', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your FeedBurner ID', 'manzil' ),
				'default' => esc_html__('themeforest', 'manzil'),
			]
		);
		$this->add_control(
              'social_icon', 
			  	[
            		'type' => Controls_Manager::REPEATER,
            		'seperator' => 'before',
            		'default' => 
						[
                			['social_link' => esc_html__('https://www.facebook.com/', 'manzil')],
                			['social_link' => esc_html__('https://www.twitter.com/', 'manzil')],
                			['social_link' => esc_html__('https://www.linkedin.com/', 'manzil')]
            			],
            		'fields' => 
						[
                			[
                    			'name' => 'icons',
                    			'label' => esc_html__('Enter The icons', 'manzil'),
                    			'type' => Controls_Manager::SELECT,
                    			'options'  => get_fontawesome_icons(),
                			],
							[
                    			'name' => 'social_link',
								'label' => __( 'Social Url', 'manzil' ),
							    'type' => Controls_Manager::URL,
							    'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
							    'show_external' => true,
							    'default' => ['url' => '','is_external' => true,'nofollow' => true,],
                			],
            			],
            	    'title_field' => '{{social_link}}',
                 ]
        );
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>
        
        <style id="clock-animations"></style>
        <!-- Coming Soon -->
        <section class="coming-soon" style="background-image: url(<?php echo esc_url($settings['bg_img']['url']); ?>);">
            <div class="content">
                <div class="content-inner">
                    <div class="auto-container">
                        <div class="logo"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url($settings['logo_img']['url']);?>" alt="<?php esc_attr_e('Awesome Image', 'manzil'); ?>" /></a></div>
                        <div class="sec-title"><h2><?php esc_html_e('Coming Soon', 'manzil'); ?></h2></div>
                        <div class="time-counter">
                            <!-- Time Countdown -->
                            <div class="time-countdown clearfix" data-countdown="<?php echo esc_attr( $settings['counter_value'] );?>"></div>
    
                            <!-- Clock / Bg Clock -->
                            <div id="clock-wrapper" class="clock-wrapper">
                                <div class="clock-base">
                                    <div class="click-indicator">
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                    </div>
                                    <div class="clock-hour"></div>
                                    <div class="clock-minute"></div>
                                    <div class="clock-second"></div>
                                    <div class="clock-center"></div>
                                </div>
                            </div>
                        </div>
                        <!--Emailed Form-->
                        <div class="emailed-form">
                            <h3><?php echo wp_kses( $settings['title'], $allowed_tags );?></h3>
                            <div class="text"><?php echo wp_kses( $settings['text'], $allowed_tags );?></div>
                            <form method="post" action="http://feedburner.google.com/fb/a/mailverify" accept-charset="utf-8">
                                <div class="form-group">
                                    <input type="hidden" id="uri2" name="uri" value="<?php echo esc_attr( $settings['form_id'] );?>">
                                    <input type="email" name="email" value="" placeholder="<?php esc_html_e('Your Email', 'manzil'); ?>" required>
                                    <button type="submit"><span class="fa fa-paper-plane"></span></button>
                                </div>
                            </form>
                        </div>
                        <ul class="social-icon-one">
                            <?php foreach($settings['social_icon'] as $item):?>
                            <li><a href="<?php echo esc_url($item['social_link']['url']); ?>"><span class="fa <?php echo esc_attr($item['icons']); ?>"></span></a></li>
                            <?php endforeach;?>
                        </ul>
                    </div>
                </div>
            </div>
        </section>
        <!-- End Coming Soon -->
		<?php 
	}

}
