<?php

namespace MANZILPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Contact_Us_V1 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'manzil_contact_us_v1';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Contact Us V1', 'manzil' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fa fa-briefcase';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'manzil' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'contact_us_v1',
			[
				'label' => esc_html__( 'Contact Us V1', 'manzil' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'manzil' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text', 'manzil' ),
			]
		);
		$this->add_control(
			'contact_form_url3',
			[
				'label'       => __( 'Contact Form 7 Url', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Contact Form 7 Url', 'manzil' ),
			]
		);
		$this->add_control(
			'title1',
			[
				'label'       => __( 'Title', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'manzil' ),
			]
		);
		$this->add_control(
			'text1',
			[
				'label'       => __( 'Text', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text', 'manzil' ),
			]
		);
		$this->add_control(
              'info', 
			  	[
            		'type' => Controls_Manager::REPEATER,
            		'seperator' => 'before',
            		'default' => 
						[
                			['block_title' => esc_html__('Phone :', 'manzil')],
                			['block_title' => esc_html__('Email :', 'manzil')],
                			['block_title' => esc_html__('Address :', 'manzil')],
            			],
            		'fields' => 
						[
                			[
                    			'name' => 'icons',
                    			'label' => esc_html__('Enter The icons', 'manzil'),
                    			'type' => Controls_Manager::SELECT,
                    			'options'  => get_fontawesome_icons(),
                			],
							[
                    			'name' => 'block_title',
                    			'label' => esc_html__('Title', 'manzil'),
                    			'type' => Controls_Manager::TEXT,
                    			'default' => esc_html__('', 'manzil')
                			],
							[
                    			'name' => 'block_description',
                    			'label' => esc_html__('Description', 'manzil'),
                    			'type' => Controls_Manager::TEXTAREA,
                    			'default' => esc_html__('Enter Description', 'manzil')
                			],
            			],
            	    'title_field' => '{{block_title}}',
                 ]
        );
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>
        
        <!-- Contact Page Section -->
        <section class="contact-page-section">
            <div class="auto-container">
                <div class="row clearfix">
                    
                    <!-- Form Column -->
                    <div class="form-column col-lg-6 col-md-12 col-sm-12">
                        <div class="inner-column">
                            <!-- Title Box -->
                            <div class="title-box">
                                <h3><?php echo wp_kses( $settings['title'], $allowed_tags );?></h3>
                                <div class="text"><?php echo wp_kses( $settings['text'], $allowed_tags );?></div>
                            </div>
                            
                            <!-- Default Form -->
                            <div class="default-form contact-form">
                                <?php echo do_shortcode( $settings['contact_form_url3'] );?>
                            </div>
                            <!--End Default Form-->
                            
                        </div>
                    </div>
                    
                    <!-- Info Column -->
                    <div class="info-column col-lg-6 col-md-12 col-sm-12">
                        <div class="inner-column">
                            <!-- Title Box -->
                            <div class="title-box">
                                <h3><?php echo wp_kses( $settings['title1'], $allowed_tags );?></h3>
                                <div class="text"><?php echo wp_kses( $settings['text1'], $allowed_tags );?></div>
                            </div>
                            
                            <ul class="contact-info">
                                <?php foreach($settings['info'] as $item):?>
                                <li>
                                    <span class="icon <?php echo esc_attr($item['icons']);?>"></span> 
                                    <strong><?php echo wp_kses($item['block_title'], $allowed_tags);?></strong>
                                    <?php echo wp_kses($item['block_description'], $allowed_tags);?>
                                </li>
                                <?php endforeach;?>
                            </ul>
                            
                        </div>
                    </div>
                    
                </div>
            </div>
        </section>
        <!-- End Contact Page Section -->
         
		<?php 
	}

}
