<?php

namespace MANZILPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class How_We_Work extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'manzil_how_we_work';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'How We Work', 'manzil' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fa fa-briefcase';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'manzil' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'how_we_work',
			[
				'label' => esc_html__( 'How We Work', 'manzil' ),
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'manzil' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'manzil' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'manzil' ),
			]
		);
		$this->add_control(
              'services', 
			  	[
            		'type' => Controls_Manager::REPEATER,
            		'seperator' => 'before',
            		'default' => 
						[
                			['title1' => esc_html__('Innovative <br> Approach', 'manzil')],
                			['title1' => esc_html__('Perfectly <br> Structured', 'manzil')],
                			['title1' => esc_html__('Affordable <br> Team', 'manzil')],
            				['title1' => esc_html__('Delivered <br> on Time', 'manzil')],
						],
            		'fields' => 
						[
                			
							[
                    			'name' => 'icons',
                    			'label' => esc_html__('Enter The icons', 'manzil'),
                    			'type' => Controls_Manager::SELECT,
                    			'options'  => get_fontawesome_icons(),
                			],
							[
                    			'name' => 'title1',
                    			'label' => esc_html__('Title', 'manzil'),
                    			'type' => Controls_Manager::TEXTAREA,
                    			'default' => esc_html__('Enter Title Here', 'manzil')
                			],
						],
            	    'title_field' => '{{title1}}',
                 ]
        );
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>
        
        <!-- Steps Section -->
        <section class="steps-section">
            <div class="auto-container">
                <!-- Sec Title -->
                <div class="sec-title centered">
                    <div class="title">
                        <!-- Title Effect -->
                        <div class="title-effect">
                            <div class="bar bar-top"></div>
                            <div class="bar bar-right"></div>
                            <div class="bar bar-bottom"></div>
                            <div class="bar bar-left"></div>
                        </div>
                        <?php echo wp_kses( $settings['subtitle'], $allowed_tags );?>
                    </div>
                    <h2><?php echo wp_kses( $settings['title'], $allowed_tags );?></h2>
                </div>
                
                <div class="row clearfix">
                    <?php $count = 1; foreach($settings['services'] as $key => $item):?>
                    <!-- Step Block -->
                    <div class="step-block col-lg-3 col-md-6 col-sm-12">
                        <div class="inner-box wow fadeInUp" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <div class="icon-box">
                                <span class="icon <?php echo esc_attr($item['icons']);?>"></span>
                                <div class="number"><?php $count = sprintf('%2d', $count); echo esc_attr($count); ?></div>
                            </div>
                            <h5><?php echo wp_kses($item['title1'], $allowed_tags);?></h5>
                        </div>
                    </div>
                    <?php $count++; endforeach;?>
                </div>
                
            </div>
        </section>
        <!-- End Steps Section -->
        
		<?php 
	}

}
