<?php

namespace MANZILPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Latest_News extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'manzil_latest_news';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Latest News', 'manzil' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fa fa-briefcase';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'manzil' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'latest_news',
			[
				'label' => esc_html__( 'Latest News', 'manzil' ),
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'manzil' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub title', 'manzil' ),
				'default'     => __( 'Our Latest New', 'manzil' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'manzil' ),
			]
		);
		$this->add_control(
			'text_limit',
			[
				'label'   => esc_html__( 'Text Limit', 'manzil' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'manzil' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'manzil' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'manzil' ),
					'title'      => esc_html__( 'Title', 'manzil' ),
					'menu_order' => esc_html__( 'Menu Order', 'manzil' ),
					'rand'       => esc_html__( 'Random', 'manzil' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'manzil' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESc' => esc_html__( 'DESC', 'manzil' ),
					'ASC'  => esc_html__( 'ASC', 'manzil' ),
				),
			]
		);
		$this->add_control(
			'query_exclude',
			[
				'label'       => esc_html__( 'Exclude', 'manzil' ),
				'type'        => Controls_Manager::TEXT,
				'description' => esc_html__( 'Exclude posts, pages, etc. by ID with comma separated.', 'manzil' ),
			]
		);
		$this->add_control(
            'query_category', 
				[
				  'type' => Controls_Manager::SELECT,
				  'label' => esc_html__('Category', 'manzil'),
				  'options' => get_blog_categories()
				]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
        $paged = manzil_set($_POST, 'paged') ? esc_attr($_POST['paged']) : 1;

		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-manzil' );
		$args = array(
			'post_type'      => 'post',
			'posts_per_page' => manzil_set( $settings, 'query_number' ),
			'orderby'        => manzil_set( $settings, 'query_orderby' ),
			'order'          => manzil_set( $settings, 'query_order' ),
			'paged'         => $paged
		);
		if ( manzil_set( $settings, 'query_exclude' ) ) {
			$settings['query_exclude'] = explode( ',', $settings['query_exclude'] );
			$args['post__not_in']      = manzil_set( $settings, 'query_exclude' );
		}
		if( manzil_set( $settings, 'query_category' ) ) $args['category_name'] = manzil_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );

		if ( $query->have_posts() ) 
		{ ?>
			
        <!-- News Section -->
        <section class="news-section">
            <div class="auto-container">
                <!-- Sec Title -->
                <div class="sec-title">
                    <div class="title">
                        <!-- Title Effect -->
                        <div class="title-effect">
                            <div class="bar bar-top"></div>
                            <div class="bar bar-right"></div>
                            <div class="bar bar-bottom"></div>
                            <div class="bar bar-left"></div>
                        </div>
                        <?php echo wp_kses( $settings['subtitle'], $allowed_tags );?>
                    </div>
                    <h2><?php echo wp_kses( $settings['title'], $allowed_tags );?></h2>
                </div>
                
                <div class="single-item-carousel owl-carousel owl-theme">
                
                    <div class="slide">
                
                        <div class="row clearfix">
                            
                            <!-- Column -->
                            <div class="column col-lg-8 col-md-12 col-sm-12">
                            
                                <!-- News Block -->
                                <div class="news-block">
                                    <div class="inner-box">
                                        <div class="image">
                                            <div class="post-date">20 / 12 / 2020</div>
                                            <a href="news-detail.html"><img src="images/resource/news-1.jpg" alt="" /></a>
                                        </div>
                                        <div class="lower-content">
                                            <ul class="post-meta">
                                                <li>24 Likes</li>
                                                <li>3 Comments</li>
                                                <li>By Admin Rose</li>
                                            </ul>
                                            <h3><a href="news-detail.html">Building Public Support For A Severige work Bond in your Smart Referendum</a></h3>
                                        </div>
                                    </div>
                                </div>
                                
                            </div>
                            
                            <!-- Column -->
                            <div class="column col-lg-4 col-md-12 col-sm-12">
                                
                                <!-- News Block Two -->
                                <div class="news-block-two">
                                    <div class="inner-box">
                                        <div class="image">
                                            <div class="post-date">20 / 12 / 2019</div>
                                            <a href="news-detail.html"><img src="images/resource/news-2.jpg" alt="" /></a>
                                        </div>
                                        <div class="lower-content">
                                            <ul class="post-meta">
                                                <li>24 Likes</li>
                                                <li>3 Comments</li>
                                                <li>By Admin Rose</li>
                                            </ul>
                                            <h4><a href="news-detail.html">High quality work for demand our customer.</a></h4>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- News Block Two -->
                                <div class="news-block-two">
                                    <div class="inner-box">
                                        <div class="image">
                                            <div class="post-date">20 / 12 / 2019</div>
                                            <a href="news-detail.html"><img src="images/resource/news-3.jpg" alt="" /></a>
                                        </div>
                                        <div class="lower-content">
                                            <ul class="post-meta">
                                                <li>24 Likes</li>
                                                <li>3 Comments</li>
                                                <li>By Admin Rose</li>
                                            </ul>
                                            <h4><a href="news-detail.html">Satisfection for the customer our first parity.</a></h4>
                                        </div>
                                    </div>
                                </div>
                                
                            </div>
                            
                        </div>
                    
                    </div>
                    
                </div>
                
            </div>
        </section>
        <!-- End News Section -->
        
        <?php }
		wp_reset_postdata();
	}

}
