<?php

namespace MANZILPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Projects_V4 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'manzil_our_projects_v4';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Projects V4', 'manzil' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fa fa-briefcase';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'manzil' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'our_projects_v4',
			[
				'label' => esc_html__( 'Our Projects V4', 'manzil' ),
			]
		);
		$this->add_control(
			'sidebar_slug',
			[
				'label'   => esc_html__( 'Choose Sidebar', 'manzil' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'Choose Sidebar',
				'options'  => manzil_get_sidebars(),
			]
		);
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'manzil' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'manzil' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'manzil' ),
					'title'      => esc_html__( 'Title', 'manzil' ),
					'menu_order' => esc_html__( 'Menu Order', 'manzil' ),
					'rand'       => esc_html__( 'Random', 'manzil' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'manzil' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESc' => esc_html__( 'DESC', 'manzil' ),
					'ASC'  => esc_html__( 'ASC', 'manzil' ),
				),
			]
		);
		$this->add_control(
			'query_exclude',
			[
				'label'       => esc_html__( 'Exclude', 'manzil' ),
				'type'        => Controls_Manager::TEXT,
				'description' => esc_html__( 'Exclude posts, pages, etc. by ID with comma separated.', 'manzil' ),
			]
		);
		$this->add_control(
            'query_category', 
				[
				  'type' => Controls_Manager::SELECT,
				  'label' => esc_html__('Category', 'manzil'),
				  'options' => get_project_categories()
				]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
        $paged = get_query_var('paged');
		$paged = manzil_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;

		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-manzil' );
		$args = array(
			'post_type'      => 'manzil_project',
			'posts_per_page' => manzil_set( $settings, 'query_number' ),
			'orderby'        => manzil_set( $settings, 'query_orderby' ),
			'order'          => manzil_set( $settings, 'query_order' ),
			'paged'         => $paged
		);
		if ( manzil_set( $settings, 'query_exclude' ) ) {
			$settings['query_exclude'] = explode( ',', $settings['query_exclude'] );
			$args['post__not_in']      = manzil_set( $settings, 'query_exclude' );
		}
		if( manzil_set( $settings, 'query_category' ) ) $args['project_cat'] = manzil_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );

		if ( $query->have_posts() ) 
		{ ?>
		
        <!-- Sidebar Page Container -->
        <div class="sidebar-page-container">
            <div class="auto-container">
                <div class="row clearfix">
                    
                    <!-- Content Side -->
                    <div class="content-side col-lg-8 col-md-12 col-sm-12">
                        <div class="our-portfolios">
                            <div class="row clearfix">
								<?php 
                                    global  $post;
									
									while ( $query->have_posts() ) : $query->the_post(); 
                                    $term_list = wp_get_post_terms(get_the_id(), 'project_cat', array("fields" => "names"));
                                	
									$post_thumbnail_id = get_post_thumbnail_id($post->ID);
            						$post_thumbnail_url = wp_get_attachment_url($post_thumbnail_id);
								?>
                                <!-- Gallery Block -->
                                <div class="gallery-block col-lg-6 col-md-6 col-sm-12">
                                    <div class="inner-box">
                                        <figure class="image-box">
                                            <?php the_post_thumbnail('manzil_370x370'); ?>
                                            <!-- Overlay Box -->
                                            <div class="overlay-box">
                                                <div class="overlay-inner">
                                                    <div class="content">
                                                        <h6><a href="<?php echo esc_url(get_post_meta( get_the_id(), 'ext_url', true ));?>"><?php the_title(); ?></a></h6>
                                                        <div class="category"><?php echo implode( ', ', (array)$term_list );?></div>
                                                    </div>
                                                </div>
                                            </div>
                                            <a href="<?php echo esc_url($post_thumbnail_url); ?>" data-fancybox="gallery-1" data-caption="" class="link"><span class="icon flaticon-full-screen"></span></a>
                                        </figure>
                                    </div>
                                </div>
                                <?php endwhile; ?>
                            </div>
                            
                            <!--Styled Pagination-->
                            <div class="styled-pagination text-center">
                                <?php manzil_the_pagination2(array('total'=>$query->max_num_pages, 'next_text' => 'Next <i class="fa fa-angle-double-right"></i> ', 'prev_text' => '<i class="fa fa-angle-double-left"></i> Prev')); ?>
                            </div>                
                            <!--End Styled Pagination-->
                            
                        </div>
                    </div>
                    
                    <!-- Sidebar Side -->
                    <div class="sidebar-side col-lg-4 col-md-12 col-sm-12">
                        <aside class="sidebar sticky-top">
                            <?php if ( is_active_sidebar( $settings['sidebar_slug'] ) ) : ?>
								<?php dynamic_sidebar( $settings['sidebar_slug'] ); ?>
                            <?php endif; ?>
                        </aside>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Sidebar Page Container -->
        
        <?php }
		wp_reset_postdata();
	}

}
