<?php

namespace MANZILPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Skills extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'manzil_our_skills';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Skills', 'manzil' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fa fa-briefcase';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'manzil' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'our_skills',
			[
				'label' => esc_html__( 'Our Skills', 'manzil' ),
			]
		);
		$this->add_control(
			'bg_image',
				[
				  'label' => __( 'Background Image', 'manzil' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				  
				]
	    );
		$this->add_control(
			'layer_image',
				[
				  'label' => __( 'Background Layer Image', 'manzil' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				  
				]
	    );
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'manzil' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'manzil' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'manzil' ),
			]
		);
		$this->add_control(
              'skills', 
			  	[
            		'type' => Controls_Manager::REPEATER,
            		'seperator' => 'before',
            		'default' => 
						[
                			['block_title' => esc_html__('General Consulting', 'manzil')],
                			['block_title' => esc_html__('Construction Management', 'manzil')],
                			['block_title' => esc_html__('Design & Build', 'manzil')]
            			],
            		'fields' => 
						[
                			[
                    			'name' => 'counter_start',
                    			'label' => esc_html__('Counter Start', 'manzil'),
                    			'type' => Controls_Manager::TEXT,
                			],
							[
                    			'name' => 'counter_stop',
                    			'label' => esc_html__('Counter Stop', 'manzil'),
                    			'type' => Controls_Manager::TEXT,
                			],
							[
                    			'name' => 'alphabet_letter',
                    			'label' => esc_html__('Alphabet Letters', 'manzil'),
                    			'type' => Controls_Manager::TEXT,
                			],
							[
                    			'name' => 'block_title',
                    			'label' => esc_html__('Title', 'manzil'),
                    			'type' => Controls_Manager::TEXT,
                    			'default' => esc_html__('Enter Title', 'manzil')
                			],
            			],
            	    'title_field' => '{{block_title}}',
                 ]
        );
		$this->add_control(
			'feature_image',
				[
				  'label' => __( 'Feature Image', 'manzil' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				  
				]
	    );
		$this->add_control(
              'skills_two', 
			  	[
            		'type' => Controls_Manager::REPEATER,
            		'seperator' => 'before',
            		'default' => 
						[
                			['block_title2' => esc_html__('General Consulting', 'manzil')],
                			['block_title2' => esc_html__('Construction Management', 'manzil')],
                			['block_title2' => esc_html__('Design & Build', 'manzil')]
            			],
            		'fields' => 
						[
                			[
                    			'name' => 'counter_start2',
                    			'label' => esc_html__('Counter Start', 'manzil'),
                    			'type' => Controls_Manager::TEXT,
                			],
							[
                    			'name' => 'counter_stop2',
                    			'label' => esc_html__('Counter Stop', 'manzil'),
                    			'type' => Controls_Manager::TEXT,
                			],
							[
                    			'name' => 'alphabet_letter2',
                    			'label' => esc_html__('Alphabet Letters', 'manzil'),
                    			'type' => Controls_Manager::TEXT,
                			],
							[
                    			'name' => 'block_title2',
                    			'label' => esc_html__('Title', 'manzil'),
                    			'type' => Controls_Manager::TEXT,
                    			'default' => esc_html__('Enter Title', 'manzil')
                			],
            			],
            	    'title_field' => '{{block_title2}}',
                 ]
        );
		$this->add_control(
            'style_two',
			[
				'label'   => esc_html__( 'Choose Spacing Style', 'manzil' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'one',
				'options' => array(
					'one' => esc_html__( 'Choose Spacing Style One', 'manzil' ),
					'two'  => esc_html__( 'Choose Spacing Style Two', 'manzil' ),
				),
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>
        
        <!-- Skill Section -->
        <section class="skill-section <?php if($settings['style_two'] == 'two') echo 'style-two'; else echo '' ;?>" style="background-image:url(<?php echo $settings['bg_image']['url'];?>)">
            <div class="image-layer" style="background-image:url(<?php echo $settings['layer_image']['url'];?>)"></div>
            <div class="auto-container">
                <!-- Sec Title -->
                <div class="sec-title centered">
                    <div class="title">
                        <!-- Title Effect -->
                        <div class="title-effect">
                            <div class="bar bar-top"></div>
                            <div class="bar bar-right"></div>
                            <div class="bar bar-bottom"></div>
                            <div class="bar bar-left"></div>
                        </div>
                        <?php echo wp_kses( $settings['subtitle'], $allowed_tags );?>
                    </div>
                    <h2><?php echo wp_kses( $settings['title'], $allowed_tags );?></h2>
                </div>
                <div class="row clearfix">
                    
                    <!-- Skill Column -->
                    <div class="skill-column col-lg-4 col-md-6 col-sm-12">
                        <div class="inner-column wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                            
                            <div class="skill-block">
                                <?php foreach($settings['skills'] as $item):?>
                                <div class="bar-item">
                                    <div class="skill-title"><?php echo wp_kses($item['block_title'], $allowed_tags);?></div>
                                    <div class="skill-bar">
                                        <div class="skill-percentage"><div class="count-box"><span class="count-text" data-speed="2000" data-stop="<?php echo esc_attr($item['counter_stop']);?>"><?php echo esc_attr($item['counter_start']);?></span><?php echo esc_attr($item['alphabet_letter']);?></div></div>
                                        <div class="bar-inner"><div class="bar progress-line" data-height="<?php echo esc_attr($item['counter_stop']);?>"></div></div>
                                    </div>
                                </div>
                                <?php endforeach;?>
                            </div>
                            
                        </div>
                    </div>
                    
                    <!-- Image Column -->
                    <div class="image-column col-lg-4 col-md-12 col-sm-12">
                        <div class="inner-column wow fadeInUp" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <div class="image">
                                <img src="<?php echo $settings['feature_image']['url'];?>" alt="<?php esc_attr_e('Awesome Image', 'manzil'); ?>" />
                            </div>
                        </div>
                    </div>
                    
                    <!-- Skill Column -->
                    <div class="skill-column right-column col-lg-4 col-md-6 col-sm-12">
                        <div class="inner-column wow fadeInRight" data-wow-delay="0ms" data-wow-duration="1500ms">
                            
                            <div class="skill-block">
                                <?php foreach($settings['skills_two'] as $item):?>
                                <div class="bar-item">
                                    <div class="skill-title"><?php echo wp_kses($item['block_title2'], $allowed_tags);?></div>
                                    <div class="skill-bar">
                                        <div class="skill-percentage"><div class="count-box"><span class="count-text" data-speed="2000" data-stop="<?php echo esc_attr($item['counter_stop2']);?>"><?php echo esc_attr($item['counter_start2']);?></span><?php echo esc_attr($item['alphabet_letter2']);?></div></div>
                                        <div class="bar-inner"><div class="bar progress-line" data-height="<?php echo esc_attr($item['counter_stop2']);?>"></div></div>
                                    </div>
                                </div>
                                <?php endforeach;?>
                            </div>
                            
                        </div>
                    </div>
                    
                </div>
            </div>
        </section>
        <!-- End Skill Section -->
        
		<?php 
	}

}
