<?php

namespace MANZILPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Pricing_Plan extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'manzil_pricing_plan';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Pricing Plan', 'manzil' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fa fa-briefcase';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'manzil' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'pricing_plan',
			[
				'label' => esc_html__( 'Pricing Plan', 'manzil' ),
			]
		);
		$this->add_control(
			'bg_img',
				[
				  'label' => __( 'Background Image', 'manzil' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'manzil' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'manzil' ),
				'default'     => __( 'Packages', 'manzil' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'manzil' ),
			]
		);
		$this->add_control(
			'monthly_title',
			[
				'label'       => __( 'Monthly Button Title', 'manzil' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Monthly Button Title', 'manzil' ),
			]
		);
		$this->add_control(
              'monthly_table', 
			  	[
            		'type' => Controls_Manager::REPEATER,
            		'seperator' => 'before',
            		'default' => 
						[
                			['block_title' => esc_html__('Just Checking', 'manzil')],
                			['block_title' => esc_html__('Maintenance', 'manzil')],
                			['block_title' => esc_html__('Add Insurance', 'manzil')]
            			],
            		'fields' => 
						[
                			[
                    			'name' => 'bg_pattern_img',
                    			'label' => __( 'Background Image', 'manzil' ),
							    'type' => Controls_Manager::MEDIA,
							    'default' => ['url' => Utils::get_placeholder_image_src(),],
                			],
							[
                    			'name' => 'block_title',
                    			'label' => esc_html__('Title', 'manzil'),
                    			'type' => Controls_Manager::TEXT,
								'default' => esc_html__('', 'manzil')
                			],
							[
                    			'name' => 'icon_img',
                    			'label' => __( 'Icon Image', 'manzil' ),
							    'type' => Controls_Manager::MEDIA,
							    'default' => ['url' => Utils::get_placeholder_image_src(),],
                			],
							[
                    			'name' => 'price',
                    			'label' => esc_html__('Price', 'manzil'),
                    			'type' => Controls_Manager::TEXT,
								'default' => esc_html__('', 'manzil')
                			],
							[
                    			'name' => 'feature_str',
                    			'label' => esc_html__('Feature List', 'manzil'),
                    			'type' => Controls_Manager::TEXTAREA,
								'default' => esc_html__('', 'manzil')
                			],
							[
                    			'name' => 'btn_title',
                    			'label' => esc_html__('Button Title', 'manzil'),
                    			'type' => Controls_Manager::TEXT,
                    			'default' => esc_html__('Get Started', 'manzil')
                			],
							[
                    			'name' => 'ext_link',
								'label' => __( 'External Url', 'manzil' ),
							    'type' => Controls_Manager::URL,
							    'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
							    'show_external' => true,
							    'default' => ['url' => '','is_external' => true,'nofollow' => true,],
                			],
            			],
            	    'title_field' => '{{block_title}}',
                 ]
        );
		$this->add_control(
			'yearly_title',
			[
				'label'       => __( 'Yearly Button Title', 'manzil' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Yearly Button Title', 'manzil' ),
			]
		);
		$this->add_control(
              'yearly_table', 
			  	[
            		'type' => Controls_Manager::REPEATER,
            		'seperator' => 'before',
            		'default' => 
						[
                			['block_title1' => esc_html__('Just Checking', 'manzil')],
                			['block_title1' => esc_html__('Maintenance', 'manzil')],
                			['block_title1' => esc_html__('Add Insurance', 'manzil')]
            			],
            		'fields' => 
						[
                			[
                    			'name' => 'bg_pattern_img1',
                    			'label' => __( 'Background Image', 'manzil' ),
							    'type' => Controls_Manager::MEDIA,
							    'default' => ['url' => Utils::get_placeholder_image_src(),],
                			],
							[
                    			'name' => 'block_title1',
                    			'label' => esc_html__('Title', 'manzil'),
                    			'type' => Controls_Manager::TEXT,
								'default' => esc_html__('', 'manzil')
                			],
							[
                    			'name' => 'icon_img1',
                    			'label' => __( 'Icon Image', 'manzil' ),
							    'type' => Controls_Manager::MEDIA,
							    'default' => ['url' => Utils::get_placeholder_image_src(),],
                			],
							[
                    			'name' => 'price1',
                    			'label' => esc_html__('Price', 'manzil'),
                    			'type' => Controls_Manager::TEXT,
								'default' => esc_html__('', 'manzil')
                			],
							[
                    			'name' => 'feature_str_two',
                    			'label' => esc_html__('Feature List', 'manzil'),
                    			'type' => Controls_Manager::TEXTAREA,
								'default' => esc_html__('', 'manzil')
                			],
							[
                    			'name' => 'btn_title1',
                    			'label' => esc_html__('Button Title', 'manzil'),
                    			'type' => Controls_Manager::TEXT,
                    			'default' => esc_html__('Get Started', 'manzil')
                			],
							[
                    			'name' => 'ext_link1',
								'label' => __( 'External Url', 'manzil' ),
							    'type' => Controls_Manager::URL,
							    'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
							    'show_external' => true,
							    'default' => ['url' => '','is_external' => true,'nofollow' => true,],
                			],
            			],
            	    'title_field' => '{{block_title1}}',
                 ]
        );
		$this->add_control(
            'style_two',
			[
				'label'   => esc_html__( 'Choose Different Style', 'manzil' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'one',
				'options' => array(
					'one' => esc_html__( 'Choose Different Style One', 'manzil' ),
					'two'  => esc_html__( 'Choose Different Style Two', 'manzil' ),
				),
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>
        	
        <!-- Pricing Section -->
        <section class="pricing-section <?php if($settings['style_two'] == 'two') echo 'style-two'; else echo '' ;?>" style="background-image:url(<?php echo $settings['bg_img']['url'];?>)">
            <div class="auto-container">
                <!-- Sec Title -->
                <div class="sec-title centered <?php if($settings['style_two'] == 'two') echo ''; else echo 'light' ;?>">
                    <div class="title">
                        <!-- Title Effect -->
                        <div class="title-effect">
                            <div class="bar bar-top"></div>
                            <div class="bar bar-right"></div>
                            <div class="bar bar-bottom"></div>
                            <div class="bar bar-left"></div>
                        </div>
                        <?php echo wp_kses( $settings['subtitle'], $allowed_tags );?>
                    </div>
                    <h2><?php echo wp_kses( $settings['title'], $allowed_tags );?></h2>
                </div>
                <div class="pricing-tabs tabs-box">
                    
                    <!--Tabs Container-->
                    <div class="tabs-content">
                        
                        <!-- Tab -->
                        <div class="tab active-tab" id="prod-monthly">
                            <div class="content">
                                <div class="row clearfix">
                                    <?php foreach($settings['monthly_table'] as $key => $item):?>
                                    <!-- Price Block -->
                                    <div class="price-block col-lg-4 col-md-6 col-sm-12">
                                        <div class="inner-box" style="background-image:url(<?php echo esc_url($item['bg_pattern_img']['url']); ?>)">
                                            <div class="title"><?php echo wp_kses($item['block_title'], $allowed_tags);?></div>
                                            <div class="image"><img src="<?php echo esc_url($item['icon_img']['url']); ?>" alt="<?php esc_attr_e('Awesome Image', 'manzil'); ?>" /></div>
                                            <div class="price"><?php echo wp_kses($item['price'], $allowed_tags);?></div>
                                            <ul class="price-list">
                                                <?php $fearures = explode("\n", ($item['feature_str']));?>
												<?php foreach($fearures as $feature):?>
                                                <li><?php echo wp_kses($feature, true); ?></li>
                                                <?php endforeach; ?>
                                            </ul>
                                            <a href="<?php echo esc_url($item['ext_link']['url']); ?>" class="theme-btn btn-style-five"><span class="txt"><?php echo wp_kses($item['btn_title'], $allowed_tags); ?></span></a>
                                        </div>
                                    </div>
                                    <?php endforeach;?>
                                </div>
                            </div>
                        </div>
                        
                        <!--Tab-->
                        <div class="tab" id="prod-yearly">
                            <div class="content">
                                <div class="row clearfix">
                                    <?php foreach($settings['yearly_table'] as $key => $item):?>
                                    <!-- Price Block -->
                                    <div class="price-block col-lg-4 col-md-6 col-sm-12">
                                        <div class="inner-box" style="background-image:url(<?php echo esc_url($item['bg_pattern_img1']['url']); ?>)">
                                            <div class="title"><?php echo wp_kses($item['block_title1'], $allowed_tags);?></div>
                                            <div class="image"><img src="<?php echo esc_url($item['icon_img1']['url']); ?>" alt="<?php esc_attr_e('Awesome Image', 'manzil'); ?>" /></div>
                                            <div class="price"><?php echo wp_kses($item['price1'], $allowed_tags);?></div>
                                            <ul class="price-list">
                                                <?php $fearures_two = explode("\n", ($item['feature_str_two']));?>
												<?php foreach($fearures_two as $feature_two):?>
                                                <li><?php echo wp_kses($feature_two, $allowed_tags); ?></li>
                                                <?php endforeach; ?>
                                            </ul>
                                            <a href="<?php echo esc_url($item['ext_link1']['url']); ?>" class="theme-btn btn-style-five"><span class="txt"><?php echo wp_kses($item['btn_title1'], $allowed_tags); ?></span></a>
                                        </div>
                                    </div>
                                    <?php endforeach;?>
                                </div>
                            </div>
                        </div>
                        
                    </div>
                    
                    <!--Tab Btns-->
                    <div class="buttons-outer">
                        <ul class="tab-buttons clearfix">
                            <li data-tab="#prod-monthly" class="tab-btn active-btn"><?php echo wp_kses( $settings['monthly_title'], $allowed_tags );?></li>
                            <li data-tab="#prod-yearly" class="tab-btn"><?php echo wp_kses( $settings['yearly_title'], $allowed_tags );?></li>
                        </ul>
                    </div>
                    
                </div>
            </div>
        </section>
        <!-- End Pricing Section -->
        
		<?php 
	}

}
