<?php

namespace MANZILPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Request_A_Quote_V2 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'manzil_request_a_quote_v2';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Request A Quote V2', 'manzil' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fa fa-briefcase';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'manzil' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'request_a_quote_v2',
			[
				'label' => esc_html__( 'Request A Quote V2', 'manzil' ),
			]
		);
		$this->add_control(
			'bg_img',
				[
				  'label' => __( 'Background Image', 'manzil' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				  
				]
	    );
		$this->add_control(
			'video_link',
				[
				  'label' => __( 'Video Url', 'manzil' ),
				  'type' => Controls_Manager::URL,
				  'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				  'show_external' => true,
				  'default' => [
				    'url' => '',
				    'is_external' => true,
				    'nofollow' => true,
				  ],
			 ]
		);
		$this->add_control(
			'video_title',
			[
				'label'       => __( 'Video Title', 'manzil' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Video Title', 'manzil' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'manzil' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text', 'manzil' ),
			]
		);
		$this->add_control(
			'pattern_img',
				[
				  'label' => __( 'Background Pattern Image', 'manzil' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				  
				]
	    );
		$this->add_control(
			'quote_image',
				[
				  'label' => __( 'Quote Image', 'manzil' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				  
				]
	    );
		$this->add_control(
			'form_title',
			[
				'label'       => __( 'Form Title', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'manzil' ),
			]
		);
		$this->add_control(
			'form_text',
			[
				'label'       => __( 'Form Description', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text', 'manzil' ),
			]
		);
		$this->add_control(
			'contact_form_url2',
			[
				'label'       => __( 'Contact Form 7 Url', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Contact Form 7 Url', 'manzil' ),
			]
		);
		
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>
        
        <!-- Request Quote Section Two -->
        <section class="request-quote-section-two">
            <div class="image-layer" style="background-image:url(<?php echo $settings['bg_img']['url'];?>)"></div>
            <div class="auto-container">
                <div class="content-box">
                    <div class="play-box">
                        <a href="<?php echo $settings['video_link']['url'];?>" class="lightbox-image play-btn"><span class="fa fa-play"><i class="ripple"></i></span></a>
                        <?php echo wp_kses( $settings['video_title'], $allowed_tags );?>
                    </div>
                    <h2><?php echo wp_kses( $settings['title'], $allowed_tags );?></h2>
                    <div class="text"><?php echo wp_kses( $settings['text'], $allowed_tags );?></div>
                </div>
                <!-- Side Image -->
                <div class="side-image wow fadeInRight" data-wow-delay="0ms" data-wow-duration="1500ms">
                    <img src="<?php echo $settings['quote_image']['url'];?>" alt="<?php esc_attr_e('Awesome Image', 'manzil'); ?>" />
                </div>
                <!-- Inner Container -->
                <div class="inner-container" style="background-image:url(<?php echo $settings['pattern_img']['url'];?>)">
                    <!-- Title Box -->
                    <div class="title-box">
                        <h2><?php echo wp_kses( $settings['form_title'], $allowed_tags );?></h2>
                        <div class="text"><?php echo wp_kses( $settings['form_text'], $allowed_tags );?></div>
                    </div>
                    
                    <!-- Default Form -->
                    <div class="default-form">
                        <?php echo do_shortcode($settings['contact_form_url2']); ?>
                    </div>
                    <!--End Default Form-->
                    
                </div>
                
            </div>
        </section>
        <!-- End Request Quote Section Two -->
      
		<?php 
	}

}
