<?php

namespace MANZILPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Service_Details extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'manzil_service_details';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Service Details', 'manzil' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fa fa-briefcase';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'manzil' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'service_details',
			[
				'label' => esc_html__( 'Service Details', 'manzil' ),
			]
		);
		$this->add_control(
			'sidebar_slug',
			[
				'label'   => esc_html__( 'Choose Sidebar', 'manzil' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'Choose Sidebar',
				'options'  => manzil_get_sidebars(),
			]
		);
		$this->add_control(
			'service_image',
			[
			  'label' => __( 'Service Image', 'manzil' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => ['url' => Utils::get_placeholder_image_src(),],
			  
			]
	    );
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'manzil' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text', 'manzil' ),
			]
		);
		$this->add_control(
			'feature_str',
			[
				'label'       => __( 'Feature List', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Feature List', 'manzil' ),
			]
		);
		$this->add_control(
			'feature_str_two',
			[
				'label'       => __( 'Feature List Two', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Feature List Two', 'manzil' ),
			]
		);
		$this->add_control(
			'service_image2',
				[
				  'label' => __( 'Feature Image One', 'manzil' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				  
				]
	    );
		$this->add_control(
			'service_image3',
				[
				  'label' => __( 'Feature Image Two', 'manzil' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				  
				]
	    );
		$this->add_control(
              'tabs', 
			  	[
            		'type' => Controls_Manager::REPEATER,
            		'seperator' => 'before',
            		'default' => 
						[
                			['block_title' => esc_html__('Personal Care', 'manzil')],
                			['block_title' => esc_html__('Super Support', 'manzil')],
                			['block_title' => esc_html__('Guaranteed', 'manzil')]
            			],
            		'fields' => 
						[
                			
							[
                    			'name' => 'block_title',
                    			'label' => esc_html__('Button Title', 'manzil'),
                    			'type' => Controls_Manager::TEXT,
                    			'default' => esc_html__('', 'manzil')
                			],
							[
                    			'name' => 'block_text',
                    			'label' => esc_html__('Description', 'manzil'),
                    			'type' => Controls_Manager::TEXTAREA,
                    			'default' => esc_html__('', 'manzil')
                			],
            			],
            	    'title_field' => '{{block_title}}',
                 ]
        );
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>
        
        <!-- Sidebar Page Container -->
        <div class="sidebar-page-container left-sidebar">
            <div class="auto-container">
                <div class="row clearfix">
                    
                    <!-- Sidebar Side -->
                    <div class="sidebar-side col-lg-4 col-md-12 col-sm-12">
                        <aside class="sidebar sticky-top">
                            <?php if ( is_active_sidebar( $settings['sidebar_slug'] ) ) : ?>
								<?php dynamic_sidebar( $settings['sidebar_slug'] ); ?>
                            <?php endif; ?>
                        </aside>
                    </div>
                    
                    <!-- Content Side -->
                    <div class="content-side col-lg-8 col-md-12 col-sm-12">
                        <div class="service-detail">
                            <div class="inner-box">
                                <div class="image">
                                    <img src="<?php echo esc_url($settings['service_image']['url']); ?>" alt="<?php esc_attr_e('Awesome Image', 'manzil'); ?>" />
                                </div>
                                <div class="lower-content">
                                    <div class="icon-box">
                                        <span class="icon flaticon-null-3"></span>
                                    </div>
                                    <h3><?php echo wp_kses( $settings['title'], $allowed_tags );?></h3>
                                    <div class="text">
                                        <?php echo wp_kses( $settings['text'], $allowed_tags );?>
                                        <div class="row clearfix">
                                            <div class="column col-lg-6 col-md-6 col-sm-12">
                                                <ul class="list-style-two">
                                                    <?php $fearures = explode("\n", ($settings['feature_str']));?>
													<?php foreach($fearures as $feature):?>
                                                    <li><?php echo wp_kses($feature, true); ?></li>
                                                    <?php endforeach; ?>
                                                </ul>
                                            </div>
                                            <div class="column col-lg-6 col-md-6 col-sm-12">
                                                <ul class="list-style-two">
                                                    <?php $fearures_one = explode("\n", ($settings['feature_str_two']));?>
													<?php foreach($fearures_one as $feature_one):?>
                                                    <li><?php echo wp_kses($feature_one, true); ?></li>
                                                    <?php endforeach; ?>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="image-gallery">
                                            <div class="row clearfix">
                                                <div class="column col-lg-6 col-md-6 col-sm-12">
                                                    <img src="<?php echo esc_url($settings['service_image2']['url']); ?>" alt="<?php esc_attr_e('Awesome Image', 'manzil'); ?>" />
                                                </div>
                                                <div class="column col-lg-6 col-md-6 col-sm-12">
                                                    <img src="<?php echo esc_url($settings['service_image3']['url']); ?>" alt="<?php esc_attr_e('Awesome Image', 'manzil'); ?>" />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Service Info Tabs -->
                            <div class="service-info-tabs">
                                <!-- Service Tabs -->
                                <div class="service-tabs tabs-box">
                                	<!--Tab Btns-->
                                    <ul class="tab-btns tab-buttons clearfix">
                                        <?php foreach($settings['tabs'] as $key => $item):?>
                                        <li data-tab="#prod-care<?php echo esc_attr($key); ?>" class="tab-btn <?php if($key == 1) echo 'active-btn'; ?>"><?php echo wp_kses($item['block_title'], $allowed_tags);?></li>
                                        <?php endforeach;?>
                                    </ul>
                                    
                                    <!--Tabs Container-->
                                    <div class="tabs-content">
                                        <?php foreach($settings['tabs'] as $key => $item):?>
                                        <!-- Tab / Active Tab -->
                                        <div class="tab <?php if($key == 1) echo 'active-tab'; ?>" id="prod-care<?php echo esc_attr($key); ?>">
                                            <div class="content">
                                                <div class="text">
                                                    <?php echo wp_kses($item['block_text'], $allowed_tags);?>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endforeach;?>
                                    </div>
                                    
                                </div>
                            </div>
                            
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
         
		<?php 
	}

}
