<?php
namespace BdevsElement\Widget;

use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Typography;
Use \Elementor\Core\Schemes\Typography;
use \Elementor\Utils;

defined( 'ABSPATH' ) || die();

class Fact extends BDevs_El_Widget {

    /**
     * Get widget name.
     *
     * Retrieve Bdevs Element widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'fact';
    }

    /**
     * Get widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'Fact', 'bdevselement' );
    }

	public function get_custom_help_url() {
		return 'http://elementor.bdevs.net//widgets/fact/';
	}

    /**
     * Get widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-save-o';
    }

    public function get_keywords() {
        return [ 'fact', 'image', 'counter' ];
    }

    protected function register_content_controls() {
        $this->start_controls_section(
            '_section_design_title',
            [
                'label' => __( 'Design Style', 'bdevselement' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'design_style',
            [
                'label' => __( 'Design Style', 'bdevselement' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __( 'Style 1', 'bdevselement' ),
                    'style_2' => __( 'Style 2', 'bdevselement' ),
                    'style_3' => __( 'Style 3', 'bdevselement' ),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );
        $this->end_controls_section();

        // title
        $this->start_controls_section(
            '_section_title',
            [
                'label' => __( 'Title & Description', 'bdevselement' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_3']
                ],
            ]
        );

        $this->add_control(
            'sub_title',
            [
                'label' => __( 'Sub Title', 'bdevselement' ),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'default' => __( 'bdevs Info Box Sub Title', 'bdevselement' ),
                'placeholder' => __( 'Type Info Box Sub Title', 'bdevselement' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'bdevselement' ),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'default' => __( 'bdevs Info Box Title', 'bdevselement' ),
                'placeholder' => __( 'Type Info Box Title', 'bdevselement' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'description',
            [
                'label' => __( 'Description', 'bdevselement' ),
                'description' => bdevs_element_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'bdevs info box description goes here', 'bdevselement' ),
                'placeholder' => __( 'Type info box description', 'bdevselement' ),
                'rows' => 5,
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );                     

        $this->add_control(
            'title_tag',
            [
                'label' => __( 'Title HTML Tag', 'bdevselement' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'h1'  => [
                        'title' => __( 'H1', 'bdevselement' ),
                        'icon' => 'eicon-editor-h1'
                    ],
                    'h2'  => [
                        'title' => __( 'H2', 'bdevselement' ),
                        'icon' => 'eicon-editor-h2'
                    ],
                    'h3'  => [
                        'title' => __( 'H3', 'bdevselement' ),
                        'icon' => 'eicon-editor-h3'
                    ],
                    'h4'  => [
                        'title' => __( 'H4', 'bdevselement' ),
                        'icon' => 'eicon-editor-h4'
                    ],
                    'h5'  => [
                        'title' => __( 'H5', 'bdevselement' ),
                        'icon' => 'eicon-editor-h5'
                    ],
                    'h6'  => [
                        'title' => __( 'H6', 'bdevselement' ),
                        'icon' => 'eicon-editor-h6'
                    ]
                ],
                'default' => 'h2',
                'toggle' => false,
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => __( 'Alignment', 'bdevselement' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'bdevselement' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'bdevselement' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'bdevselement' ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();   

        $this->start_controls_section(
            '_section_slides',
            [
                'label' => __( 'Fact List', 'bdevselement' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'type',
            [
                'label' => __( 'Media Type', 'bdevselement' ),
                'type' => Controls_Manager::CHOOSE,
                'label_block' => false,
                'options' => [
                    'icon' => [
                        'title' => __( 'Icon', 'bdevselement' ),
                        'icon' => 'fa fa-smile-o',
                    ],
                    'image' => [
                        'title' => __( 'Image', 'bdevselement' ),
                        'icon' => 'fa fa-image',
                    ],
                ],
                'default' => 'icon',
                'toggle' => false,
                'style_transfer' => true,
            ]
        );

        $repeater->add_control(
            'image',
            [
                'label' => __( 'Image', 'bdevselement' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'type' => 'image'
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'medium_large',
                'separator' => 'none',
                'exclude' => [
                    'full',
                    'custom',
                    'large',
                    'shop_catalog',
                    'shop_single',
                    'shop_thumbnail'
                ],
                'condition' => [
                    'type' => 'image'
                ]
            ]
        );

        if ( bdevs_element_is_elementor_version( '<', '2.6.0' ) ) {
            $repeater->add_control(
                'icon',
                [
                    'label' => __( 'Icon', 'bdevselement' ),
                    'label_block' => true,
                    'type' => Controls_Manager::ICON,
                    'options' => bdevs_element_get_bdevs_element_icons(),
                    'default' => 'fa fa-smile-o',
                    'condition' => [
                        'type' => 'icon'
                    ]
                ]
            );
        } 
        else {
            $repeater->add_control(
                'selected_icon',
                [
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'fas fa-smile-wink',
                        'library' => 'fa-solid',
                    ],
                    'condition' => [
                        'type' => 'icon'
                    ]
                ]
            );
        }  

        $repeater->add_control(
            'skill_color',
            [
                'label' => __( 'Skill Line Color', 'bdevselement' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#FF5E14',
                // 'selectors' => [
                //     '{{WRAPPER}} .section-title' => 'color: {{VALUE}};',
                // ],
            ]
        );

        $repeater->add_control(
            'number',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => __( 'Circle Number', 'bdevselement' ),
                'default' => __( '70', 'bdevselement' ),
                'placeholder' => __( 'Type title here', 'bdevselement' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );          

        $repeater->add_control(
            'back_number',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __( '70', 'bdevselement' ),
                'label' => __( 'Back Number', 'bdevselement' ),
                'placeholder' => __( 'Type title here', 'bdevselement' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );        

        $repeater->add_control(
            'subtitle',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => __( 'Subtitle', 'bdevselement' ),
                'placeholder' => __( 'Type sub title here', 'bdevselement' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'description',
            [
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'show_label' => false,
                'label' => __( 'Description', 'bdevselement' ),
                'placeholder' => __( 'Type description here', 'bdevselement' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'slides',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '<# print(subtitle || "Carousel Item"); #>',
                'default' => [
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                ]
            ]
        );

        $this->end_controls_section();

        // img
        $this->start_controls_section(
            '_section_about_image',
            [
                'label' => __( 'Image', 'bdevselement' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_3']
                ],
            ]
        );

        $this->add_control(
            'bg_image',
            [
                'label' => __( 'Image', 'bdevselement' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );                 

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'large',
                'separator' => 'none',
            ]
        );        


        $this->end_controls_section();  


        $this->start_controls_section(
            '_section_button',
            [
                'label' => __( 'Button', 'bdevselement' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_5']
                ],
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => __( 'Text', 'bdevselement' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Button Text', 'bdevselement' ),
                'placeholder' => __( 'Type button text here', 'bdevselement' ),
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'button_link',
            [
                'label' => __( 'Link', 'bdevselement' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'http://elementor.bdevs.net/', 'bdevselement' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        if ( bdevs_element_is_elementor_version( '<', '2.6.0' ) ) {
            $this->add_control(
                'button_icon',
                [
                    'label' => __( 'Icon', 'bdevselement' ),
                    'label_block' => true,
                    'type' => Controls_Manager::ICON,
                    'options' => bdevs_element_get_bdevs_element_icons(),
                    'default' => 'fa fa-angle-right',
                ]
            );

            $condition = ['button_icon!' => ''];
        } else {
            $this->add_control(
                'button_selected_icon',
                [
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'button_icon',
                    'label_block' => true,
                ]
            );
            $condition = ['button_selected_icon[value]!' => ''];
        }

        $this->add_control(
            'button_icon_position',
            [
                'label' => __( 'Icon Position', 'bdevselement' ),
                'type' => Controls_Manager::CHOOSE,
                'label_block' => false,
                'options' => [
                    'before' => [
                        'title' => __( 'Before', 'bdevselement' ),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'after' => [
                        'title' => __( 'After', 'bdevselement' ),
                        'icon' => 'eicon-h-align-right',
                    ],
                ],
                'default' => 'after',
                'toggle' => false,
                'condition' => $condition,
                'style_transfer' => true,
            ]
        );

        $this->add_control(
            'button_icon_spacing',
            [
                'label' => __( 'Icon Spacing', 'bdevselement' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 10
                ],
                'condition' => $condition,
                'selectors' => [
                    '{{WRAPPER}} .btn--icon-before .btn-icon' => 'margin-right: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .btn--icon-after .btn-icon' => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function register_style_controls() {

        // _section_style_title_content
        $this->start_controls_section(
            '_section_style_title_content',
            [
                'label' => __( 'Title / Content', 'bdevselement' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'design_style' => ['style_3']
                ],
            ]
        );

            // Title
            $this->add_control(
                '_section-heading_title',
                [
                    'type' => Controls_Manager::HEADING,
                    'label' => __( 'Title', 'bdevselement' ),
                    'separator' => 'before'
                ]
            );

            $this->add_responsive_control(
                'section-title_spacing',
                [
                    'label' => __( 'Bottom Spacing', 'bdevselement' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-el-section-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'section-title_color',
                [
                    'label' => __( 'Text Color', 'bdevselement' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-el-section-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'section-title',
                    'selector' => '{{WRAPPER}} .bdevs-el-section-title',
                    'scheme' => Typography::TYPOGRAPHY_2,
                ]
            );

            // Subtitle    
            $this->add_control(
                '_section-heading_subtitle',
                [
                    'type' => Controls_Manager::HEADING,
                    'label' => __( 'Subtitle', 'bdevselement' ),
                    'separator' => 'before'
                ]
            );

            $this->add_responsive_control(
                'section-subtitle_spacing',
                [
                    'label' => __( 'Bottom Spacing', 'bdevselement' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-el-section-subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'section-subtitle_color',
                [
                    'label' => __( 'Text Color', 'bdevselement' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-el-section-subtitle' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'section-subtitle',
                    'selector' => '{{WRAPPER}} .bdevs-el-section-subtitle',
                    'scheme' => Typography::TYPOGRAPHY_3,
                ]
            );

        $this->end_controls_section();


        // Counter Content
        $this->start_controls_section(
            '_section_style_content',
            [
                'label' => __( 'Counter Content', 'bdevselement' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_responsive_control(
                'content_padding',
                [
                    'label' => __( 'Content Padding', 'bdevselement' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-el-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'content_background',
                    'selector' => '{{WRAPPER}} .bdevs-el-content',
                    'exclude' => [
                        'image'
                    ]
                ]
            );

            // Title
            $this->add_control(
                '_heading_title',
                [
                    'type' => Controls_Manager::HEADING,
                    'label' => __( 'Title', 'bdevselement' ),
                    'separator' => 'before'
                ]
            );

            $this->add_responsive_control(
                'title_spacing',
                [
                    'label' => __( 'Bottom Spacing', 'bdevselement' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-el-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'title_color',
                [
                    'label' => __( 'Text Color', 'bdevselement' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-el-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title',
                    'selector' => '{{WRAPPER}} .bdevs-el-title',
                    'scheme' => Typography::TYPOGRAPHY_2,
                ]
            );

            // Subtitle    
            $this->add_control(
                '_heading_subtitle',
                [
                    'type' => Controls_Manager::HEADING,
                    'label' => __( 'Subtitle', 'bdevselement' ),
                    'separator' => 'before'
                ]
            );

            $this->add_responsive_control(
                'subtitle_spacing',
                [
                    'label' => __( 'Bottom Spacing', 'bdevselement' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-el-subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'subtitle_color',
                [
                    'label' => __( 'Text Color', 'bdevselement' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-el-subtitle' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'subtitle',
                    'selector' => '{{WRAPPER}} .bdevs-el-subtitle',
                    'scheme' => Typography::TYPOGRAPHY_3,
                ]
            );

            // number
            $this->add_control(
                '_content_description',
                [
                    'type' => Controls_Manager::HEADING,
                    'label' => __( 'Number', 'bdevselement' ),
                    'separator' => 'before'
                ]
            );

            $this->add_responsive_control(
                'description_spacing',
                [
                    'label' => __( 'Bottom Spacing', 'bdevselement' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-el-number' => 'margin-bottom: {{SIZE}}{{UNIT}} !important;',
                    ],
                ]
            );

            $this->add_control(
                'description_color',
                [
                    'label' => __( 'Text Color', 'bdevselement' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-el-number' => 'color: {{VALUE}} !important',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'description',
                    'selector' => '{{WRAPPER}} .bdevs-el-number',
                    'scheme' => Typography::TYPOGRAPHY_4,
                ]
            );


        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings_for_display();

        $this->add_inline_editing_attributes( 'title', 'basic' );
        $this->add_render_attribute( 'title_2', 'class', 'section-title white-color bdevs-el-title' );
        $this->add_render_attribute( 'title', 'class', 'title bdevs-el-section-title' );

        // button
        if (!empty($settings['button_link'])) {
            $this->add_inline_editing_attributes( 'button_text', 'none' );
            $this->add_render_attribute( 'button_text', 'class', 'bdevs-btn-text' );
            $this->add_render_attribute( 'button', 'class', 'bdevs-btn bt-btn' );
            $this->add_link_attributes( 'button', $settings['button_link'] );
        }

        $this->add_inline_editing_attributes( 'description', 'intermediate' );
        $this->add_render_attribute( 'description', 'class', 'bdevs-card-text' );

        $title = bdevs_element_kses_basic( $settings['title' ] );

        if ( empty( $settings['slides'] ) ) {
            return;
        }
        ?>

        <?php if ( $settings['design_style'] === 'style_1' ): ?>
        <section class="counter1 bdevs-el-content" id="counter1" >
            <div class="counter1__wrapper position-relative">
                <?php if ( $settings['back_title'] ) : ?>
                <h2 class="text-border-title1 features1-style d-none"><?php echo bdevs_element_kses_intermediate( $settings['back_title'] ); ?></h2>
                <?php endif; ?>
                <div class="content_box_120_70 p-0">
                    <div class="container">
                        <div class="row mb-55 d-none">
                            <div class="col-lg-8 offset-lg-2">
                                <div class="title_style1 text-center">
                                    <?php if ( $settings['sub_title'] ) : ?>
                                        <h5 class="sub-title bdevs-el-subtitle"><?php echo bdevs_element_kses_intermediate( $settings['sub_title'] ); ?></h5>
                                    <?php endif; ?>

                                    <?php printf( '<%1$s %2$s>%3$s</%1$s>',
                                        tag_escape( $settings['title_tag'] ),
                                        $this->get_render_attribute_string( 'title' ),
                                        $title
                                    ); ?>
                                </div>
                            </div>
                        </div>  

                        <div class="row">
                            <?php foreach ( $settings['slides'] as $key => $slide ) : ?>
                            <div class="col-xl-3 col-sm-6 text-center">
                                <div class="counter1__item mb-50 bdevs-el-content">
                                    <div class="progress-circular mb-30">
                                        <input type="text" class="knob bdevs-el-number" value="0" data-rel="<?php echo bdevs_element_kses_basic( $slide['number'] ); ?>" data-linecap="round"
                                           data-width="200" data-height="200" data-bgcolor="#314D79" data-fgcolor="<?php echo bdevs_element_kses_basic( $slide['skill_color'] ); ?>" data-thickness=".10" data-readonly="true" disabled/>
                                    </div>
                                    <div class="counter1__content">
                                        <?php if ( !empty( $slide['back_number'] ) ) : ?>
                                        <h3 class="counter1__content--bg"><?php echo bdevs_element_kses_basic( $slide['back_number'] ); ?></h3>
                                        <?php endif; ?>
                                        <?php if ( !empty( $slide['subtitle'] ) ) : ?>
                                        <h4 class="bdevs-el-title"><?php echo bdevs_element_kses_basic( $slide['subtitle'] ); ?></h4>
                                        <?php endif; ?>
                                        <?php if ( !empty( $slide['description'] ) ) : ?>
                                        <p class="bdevs-el-subtitle  "><?php echo bdevs_element_kses_basic( $slide['description'] ); ?></p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <?php elseif ( $settings['design_style'] === 'style_2' ): ?>
        <section class="counter1 home3">
            <div class="counter1__wrapper position-relative">
                <div class="content_box_120_70 p-0">
                    <div class="container">
                        <div class="row">
                            <?php foreach ( $settings['slides'] as $key => $slide ) : ?>
                            <div class="col-xl-3 col-sm-6 text-center bdevs-el-content">
                                <div class="counter1__item counter1__item-white mb-50">
                                    <div class="progress-circular mb-30">
                                        <input type="text" class="knob bdevs-el-number" value="0" data-rel="<?php echo bdevs_element_kses_basic( $slide['number'] ); ?>" data-linecap="round"
                                           data-width="200" data-height="200" data-bgcolor="#314D79" data-fgcolor="<?php echo bdevs_element_kses_basic( $slide['skill_color'] ); ?>" data-thickness=".10" data-readonly="true" disabled/>
                                    </div>
                                    <div class="counter1__content">
                                        <?php if ( !empty( $slide['back_number'] ) ) : ?>
                                        <h3 class="counter1__content--bg"><?php echo bdevs_element_kses_basic( $slide['back_number'] ); ?></h3>
                                        <?php endif; ?>
                                        <?php if ( !empty( $slide['subtitle'] ) ) : ?>
                                        <h4 class="bdevs-el-title"><?php echo bdevs_element_kses_basic( $slide['subtitle'] ); ?></h4>
                                        <?php endif; ?>
                                        <?php if ( !empty( $slide['description'] ) ) : ?>
                                        <p class="bdevs-el-subtitle"><?php echo bdevs_element_kses_basic( $slide['description'] ); ?></p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>       

        <?php elseif ( $settings['design_style'] === 'style_3' ): 
            // bg_image
            if (!empty($settings['bg_image']['id'])) {
                $bg_image = wp_get_attachment_image_url( $settings['bg_image']['id'], $settings['thumbnail_size'] );
                if ( ! $bg_image ) {
                    $bg_image = $settings['bg_image']['url'];
                }
            }    
        ?>
        <section class="features2">
            <div class="features2__item1">
                <div class="features2__thumb1" data-background="<?php echo esc_url($bg_image); ?>"></div>
                <div class="container-fluid">
                    <div class="row no-gutters">
                        <div class="col-xl-6 offset-xl-6">
                            <div class="features2__item1__wrapper">
                                <div class="title_style1 mb-65">
                                    <?php if ( $settings['sub_title'] ) : ?>
                                        <h5 class="sub-title bdevs-el-section-subtitle"><?php echo bdevs_element_kses_intermediate( $settings['sub_title'] ); ?></h5>
                                    <?php endif; ?>

                                    <?php printf( '<%1$s %2$s>%3$s</%1$s>',
                                        tag_escape( $settings['title_tag'] ),
                                        $this->get_render_attribute_string( 'title' ),
                                        $title
                                    ); ?>
                                </div>
                                <div class="row">
                                    <?php foreach ( $settings['slides'] as $key => $slide ) : ?>
                                    <div class="col-sm-6 text-center">
                                        <div class="counter1__item mb-50 bdevs-el-content">
                                            <div class="progress-circular mb-30">
                                                <input type="text" class="knob bdevs-el-number" value="0" data-rel="<?php echo bdevs_element_kses_basic( $slide['number'] ); ?>" data-linecap="round"
                                                   data-width="200" data-height="200" data-bgcolor="#314D79" data-fgcolor="<?php echo bdevs_element_kses_basic( $slide['skill_color'] ); ?>" data-thickness=".10" data-readonly="true" disabled/>
                                            </div>
                                            <div class="counter1__content">
                                                <?php if ( !empty( $slide['back_number'] ) ) : ?>
                                                <h3 class="counter1__content--bg bdevs-el-subtitle"><?php echo bdevs_element_kses_basic( $slide['back_number'] ); ?></h3> 
                                                <?php endif; ?>
                                                <?php if ( !empty( $slide['subtitle'] ) ) : ?>
                                                <h4 class="bdevs-el-title"><?php echo bdevs_element_kses_basic( $slide['subtitle'] ); ?></h4>
                                                <?php endif; ?>
                                                <?php if ( !empty( $slide['description'] ) ) : ?>
                                                <p><?php echo bdevs_element_kses_basic( $slide['description'] ); ?></p>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>     

         <?php endif; ?>   

        <?php
    }
}
