<?php
class HappyForms_Integration_Email {

	private static $instance;

	public $service = '';

	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		self::$instance->hook();

		return self::$instance;
	}

	public function hook() {
		require_once( happyforms_get_integrations_folder() . '/services/email/class-part-email-integration.php' );

		add_filter( 'happyforms_library_get_part_mailchimp', array( $this, 'library_get_part' ) );
		add_filter( 'happyforms_customize_get_current_form', array( $this, 'customize_get_current_form' ) );
		add_filter( 'happyforms_get_first_part_by_type_email_integration', array( $this, 'get_first_part_by_type' ), 10, 2 );
		add_filter( 'happyforms_get_form_data', array( $this, 'filter_preview_only_parts' ) );
	}

	public function library_get_part( $part ) {
		$part = happyforms_get_part_library()->get_part( 'email_integration' );

		return $part;
	}

	public function customize_get_current_form( $form ) {
		foreach( $form['parts'] as $p => $part ) {
			if ( 'mailchimp' === $part['type'] ) {
				$form['parts'][$p]['type'] = 'email_integration';
			}
		}

		return $form;
	}

	public function get_first_part_by_type( $part, $form ) {
		if ( $part ) {
			return $part;
		}

		$part = happyforms_get_form_controller()->get_first_part_by_type( $form, 'mailchimp' );

		return $part;
	}

	public function has_active_email_service() {
		$has_active_service = false;
		$email_services = happyforms_get_integrations()->get_service_group( 'email' );

		foreach( $email_services as $service ){
			if( $service->is_connected() ) {
				$has_active_service = true;
				break;
			}
		}

		return $has_active_service;
	}

	public function filter_preview_only_parts( $form ) {
		if ( happyforms_is_preview() || happyforms_is_form_edit_screen() || is_admin() ) {
			return $form;
		}

		if ( ! $this->has_active_email_service() ) {
			$parts = array();

			foreach ( $form['parts'] as $part ) {
				if ( 'email_integration' !== $part['type'] ) {
					$parts[] = $part;
				}
			}

			$form['parts'] = $parts;
		}

		return $form;
	}

}

if ( ! function_exists( 'happyforms_get_email_integration' ) ):

function happyforms_get_email_integration() {
	return HappyForms_Integration_Email::instance();
}

endif;

happyforms_get_email_integration();
