<?php

class HappyForms_Integration_Thrive_Automator {

	private static $instance;
	private static $hooked = false;
	private $service;

	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		self::$instance->hook();

		return self::$instance;
	}

	public function __construct() {
		
	}

	public function hook() {
		add_action( 'thrive_automator_init', array( $this, 'register_application' ) );
	}

	public function register_application() {
		require_once( happyforms_get_integrations_folder() . '/services/thrive-automator/class-integration-thrive-app.php' );
		require_once( happyforms_get_integrations_folder() . '/services/thrive-automator/class-integration-thrive-trigger.php' );
		require_once( happyforms_get_integrations_folder() . '/services/thrive-automator/class-integration-thrive-trigger-form-field.php' );
		require_once( happyforms_get_integrations_folder() . '/services/thrive-automator/class-integration-thrive-trigger-email-field.php' );
		require_once( happyforms_get_integrations_folder() . '/services/thrive-automator/class-integration-thrive-data-object.php' );

		thrive_automator_register_app( HappyForms_Thrive_Automator_App::class );
		thrive_automator_register_trigger( HappyForms_Thrive_Automator_Trigger::class );
		thrive_automator_register_trigger_field( HappyForms_Thrive_Automator_Trigger_Form_Field::class );
		thrive_automator_register_trigger_field( HappyForms_Thrive_Automator_Trigger_Email_Field::class );
		thrive_automator_register_data_object( HappyForms_Thrive_Automator_Data_Object::class );
	}

}

if ( ! function_exists( 'happyforms_get_integration_thrive_automator' ) ):

function happyforms_get_integration_thrive_automator() {
	$instance = HappyForms_Integration_Thrive_Automator::instance();
	
	return $instance;
}

endif;

happyforms_get_integration_thrive_automator();