<?php
/**
 * 404 page file
 *
 * @package    WordPress
 * @subpackage Manzil
 * @author     YogsThemes <admin@yogsthemes.com>
 * @version    1.0
 */

$text = sprintf(__('It seems we can\'t find what you\'re looking for. Perhaps searching can help', 'manzil'), esc_url(home_url('/')));

$allowed_html = wp_kses_allowed_html( 'post' );
?>
<?php get_header();
$data = \MANZIL\Includes\Classes\Common::instance()->data( '404' )->get();

$options = manzil_WSH()->option();
if ( class_exists( '\Elementor\Plugin' ) AND $data->get( 'tpl-type' ) == 'e' AND $data->get( 'tpl-elementor' ) ) {
	echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $data->get( 'tpl-elementor' ) );
} else {
?>

	<?php if ( class_exists( '\Elementor\Plugin' )): ?>
	<?php do_action( 'manzil_banner', $data ); ?>
	<?php else: ?>
    
    <!-- Page Title -->
    <section class="page-title" style="background-image: url('<?php echo esc_url( $data->get( 'banner' ) ); ?>')">
        <div class="auto-container">
            <h1><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h1>
            <ul class="page-breadcrumb">
                <?php echo manzil_the_breadcrumb(); ?>
            </ul>
        </div>
    </section>
    <!-- End Page Title -->
    <?php endif; ?>
	
    <!-- Error Section -->
    <section class="error-section">
    	<div class="auto-container">
        	<div class="content">
            	<h1><?php echo wp_kses( $options->get( '404-page_title' ), $allowed_html ) ? wp_kses( $options->get( '404-page_title' ), $allowed_html ) : esc_html_e( '404', 'manzil' ); ?></h1>
                <h2><?php echo wp_kses( $options->get( '404-page_tagline' ), $allowed_html ) ? wp_kses( $options->get( '404-page_tagline' ), $allowed_html ) : esc_html_e( 'Oops! That page can’t be found', 'manzil' ); ?></h2>
                <div class="text"><?php echo wp_kses( $options->get('404-page-text'), $allowed_html ) ? wp_kses($options->get('404-page-text' ), $allowed_html ) : $text; ?></div>
                <?php if ( $options->get( 'back_home_btn', true ) ) : ?>
                <a href="<?php echo( home_url( '/' ) ); ?>" class="theme-btn btn-style-three"><span class="txt"><?php echo wp_kses( $options->get('back_home_btn_label'), $allowed_html ) ? wp_kses( $options->get('back_home_btn_label'), $allowed_html ) : esc_html_e( 'Go To Home Page', 'manzil' ); ?></span></a>
            	<?php endif; ?>
            </div>
        </div>
    </section>
    <!-- End Error Section -->
         
<?php
}
get_footer(); ?>
