<?php
$styles = [];
foreach(range(1, 28) as $val) {
    $styles[$val] = sprintf(esc_html__('Style %s', 'manzil'), $val);
}

return  array(
    'title'      => esc_html__( 'General Setting', 'manzil' ),
    'id'         => 'general_setting',
    'desc'       => '',
    'icon'       => 'el el-wrench',
    'fields'     => array(
        array(
            'id' => 'theme_preloader',
            'type' => 'switch',
            'title' => esc_html__('Enable Preloader', 'manzil'),
            'default' => false,
        ),
		array(
            'id' => 'preloader_image_show',
            'type' => 'switch',
            'title' => esc_html__('Enable Preloader Image', 'manzil'),
            'default' => true,
        ),
		array(
			'id'       => 'preloader_img',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Preloader Image', 'manzil' ),
			'subtitle' => esc_html__( 'Insert Preloader Image in svg or gif', 'manzil' ),
			'required' => array( 'preloader_image_show', '=', true ),
		),
		array(
            'id' => 'custom_scheme_show',
            'type' => 'switch',
            'title' => esc_html__('Enable Custom Color Scheme', 'manzil'),
            'default' => false,
        ),
		array(
			'id'       => 'main_color_scheme',
			'type'     => 'color',
			'title'    => esc_html__( 'Main Custom Color Scheme', 'manzil' ),
			'subtitle' => esc_html__( 'Choose the Custom color scheme for the theme', 'manzil' ),
			'required' => array( 'custom_scheme_show', '=', true ),
		),
    ),
);
