<?php
/**
 * Footer Template  File
 *
 * @package MANZIL
 * @author  YogsThemes
 * @version 1.0
 */

$options = manzil_WSH()->option();

$bg_img    = $options->get( 'footer_bg_img' );
$bg_img    = manzil_set( $bg_img, 'url', MANZIL_URI . 'assets/images/background/5.jpg' );

$allowed_html = wp_kses_allowed_html( 'post' );
?>

<!-- Main Footer -->
<footer class="main-footer" style="background-image:url(<?php echo esc_url($bg_img);?>)">
    <?php if ( is_active_sidebar( 'footer-sidebar' ) ) { ?>
    <div class="auto-container">
        <!--Widgets Section-->
        <div class="widgets-section">
            <div class="row clearfix">
                <?php dynamic_sidebar( 'footer-sidebar' ); ?>
            </div>
        </div>
    </div>
    <?php } ?>
    
    <!-- Footer Bottom -->
    <div class="footer-bottom">
        <div class="auto-container">
            <div class="row clearfix">
                <!-- Column -->
                <div class="column col-lg-6 col-md-12 col-sm-12">
                    <div class="copyright"><?php echo wp_kses( $options->get( 'copyright_text', '&copy; All rights reserved by <a href="#">Yogsthemes</a>' ), $allowed_html ); ?></div>
                </div>
                <?php if($options->get( 'footer_menu' )):?>
                <!-- Column -->
                <div class="column col-lg-6 col-md-12 col-sm-12">
                    <ul class="footer-nav">
                        <?php echo wp_kses( $options->get( 'footer_menu'), $allowed_html ); ?>
                    </ul>
                </div>
                <?php endif;?>
            </div>
        </div>
    </div>
    
</footer>
<!-- End Main Footer -->