<?php
$options = manzil_WSH()->option();
$allowed_html = wp_kses_allowed_html( 'post' );

$image_logo = $options->get( 'image_normal_logo' );
$logo_dimension = $options->get( 'normal_logo_dimension' );

$image_logo2 = $options->get( 'image_normal_logo2' );
$logo_dimension2 = $options->get( 'normal_logo_dimension2' );

$image_logo3 = $options->get( 'image_normal_logo3' );
$logo_dimension3 = $options->get( 'normal_logo_dimension3' );

$logo_type = '';
$logo_text = '';
$logo_typography = '';
?>
    
    <!-- Main Header / Header Style Two -->
    <header class="main-header header-style-two">
    
        <!-- Header Top Two -->
        <?php if( $options->get( 'show_topbar_v2' ) ):?>
        <div class="header-top-two">
            <div class="auto-container">
                <div class="inner-container clearfix">
                    <!-- Top Left -->
                    <div class="top-left clearfix">
						<ul class="top-list">
							<?php if( $options->get('address_v2') ):?><li><span class="icon flaticon-maps-and-flags"></span><?php echo wp_kses($options->get('address_v2'), $allowed_html);?></li><?php endif; ?>
							<?php if( $options->get('phone_no_v2') ):?><li><span class="icon flaticon-telephone"></span><a href="tel:<?php echo esc_url($options->get('phone_no_v2'));?>"><?php echo wp_kses($options->get('phone_no_v2'), $allowed_html);?></a></li><?php endif; ?>
						</ul>
                    </div>
					<?php
						$icons = $options->get( 'header_v2_social_share' );
						if ( ! empty( $icons ) ) :
					?>
					<!-- Top Right -->
                    <div class="top-right clearfix">
						<!-- Social Box -->
						<ul class="social-box">
						<?php
							foreach ( $icons as $h_icon ) :
							$header_social_icons = json_decode( urldecode( manzil_set( $h_icon, 'data' ) ) );
							if ( manzil_set( $header_social_icons, 'enable' ) == '' ) {
								continue;
							}
							$icon_class = explode( '-', manzil_set( $header_social_icons, 'icon' ) );
							?>
							<li><a href="<?php echo esc_url(manzil_set( $header_social_icons, 'url' )); ?>" style="background-color:<?php echo esc_attr(manzil_set( $header_social_icons, 'background' )); ?>; color: <?php echo esc_attr(manzil_set( $header_social_icons, 'color' )); ?>" class="fa <?php echo esc_attr( manzil_set( $header_social_icons, 'icon' ) ); ?>"></a></li>
						<?php endforeach; ?>
                        </ul>
					</div>
					<?php endif; ?>
                </div>
            </div>
        </div>
		<?php endif;?>
        <!--Header Lower-->
        <div class="header-lower <?php if(! $options->get( 'show_topbar_v2' ) ) echo 'adjustment';?>">
            
            <div class="auto-container">
				<div class="clearfix">

					<!-- Logo Box -->
					<div class="pull-left logo-box">
						<div class="logo">
                        	<?php if( manzil_logo( $logo_type, $image_logo3, $logo_dimension3, $logo_text, $logo_typography ) ):?>
							<?php echo manzil_logo( $logo_type, $image_logo3, $logo_dimension3, $logo_text, $logo_typography ); ?>
                        	<?php else :?>
                                <img src="<?php echo esc_url( get_template_directory_uri(). '/assets/images/logo-2.png' );?>">
                            <?php endif;?>
                        </div>
					</div>
				
					<div class="nav-outer clearfix">
						<!-- Mobile Navigation Toggler -->
						<div class="mobile-nav-toggler"><span class="icon flaticon-menu-2"></span></div>
						<!-- Main Menu -->
						<nav class="main-menu show navbar-expand-md">
							<div class="navbar-header">
								<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
									<span class="icon-bar"></span>
									<span class="icon-bar"></span>
									<span class="icon-bar"></span>
								</button>
							</div>
							
							<div class="navbar-collapse collapse clearfix" id="navbarSupportedContent">
								<ul class="navigation clearfix">
									<?php wp_nav_menu( array( 'theme_location' => 'main_menu', 'container_id' => 'navbar-collapse-1',
                                        'container_class'=>'navbar-collapse collapse navbar-right',
                                        'menu_class'=>'nav navbar-nav',
                                        'fallback_cb'=>false, 
                                        'items_wrap' => '%3$s', 
                                        'container'=>false,
                                        'depth'=>'3',
                                        'walker'=> new Bootstrap_walker()  
                                    ) ); ?>
								</ul>
							</div>
						</nav>
						<!-- Main Menu End-->

						<!-- Options Box -->
						<div class="options-box clearfix">
							<?php if( $options->get('search_form_icon_v2') ):?>
							<!--Search Box-->
							<div class="search-box-outer">
								<div class="search-box-btn"><span class="fa fa-search"></span></div>
							</div>
							<?php endif; ?>
							<?php if( $options->get('btn_title_v2') ):?>
							<div class="btn-box">
								<a href="<?php echo esc_url($options->get('btn_link_v2'));?>" class="theme-btn btn-style-three"><span class="txt"><?php echo wp_kses($options->get('btn_title_v2'), $allowed_html);?></span></a>
							</div>
							<?php endif; ?>
						</div>
						
					</div>
				</div>
            </div>
        </div>
        <!-- End Header Lower -->
        
		<!-- Sticky Header  -->
        <div class="sticky-header">
            <div class="auto-container clearfix">
                <!--Logo-->
                <div class="logo pull-left">
                    <?php if( manzil_logo( $logo_type, $image_logo2, $logo_dimension2, $logo_text, $logo_typography ) ):?>
					<?php echo manzil_logo( $logo_type, $image_logo2, $logo_dimension2, $logo_text, $logo_typography ); ?>
                	<?php else :?>
                    	<img src="<?php echo esc_url( get_template_directory_uri(). '/assets/images/logo-small.png' );?>">
                    <?php endif;?>
                </div>
                <!--Right Col-->
                <div class="pull-right">
                    <!-- Main Menu -->
                    <nav class="main-menu">
                        <!--Keep This Empty / Menu will come through Javascript-->
                    </nav><!-- Main Menu End-->
					
					<!-- Options Box -->
					<div class="options-box clearfix">
						<?php if( $options->get('search_form_icon_v2') ):?>
						<!--Search Box-->
						<div class="search-box-outer">
							<div class="search-box-btn"><span class="fa fa-search"></span></div>
						</div>
						<?php endif; ?>
						<?php if( $options->get('btn_title_v2') ):?>
						<div class="btn-box">
							<a href="<?php echo esc_url($options->get('btn_link_v2'));?>" class="theme-btn btn-style-one"><span class="txt"><?php echo wp_kses($options->get('btn_title_v2'), $allowed_html);?></span></a>
						</div>
						<?php endif; ?>
					</div>
					
                </div>
            </div>
        </div><!-- End Sticky Menu -->
		
        <!-- Mobile Menu  -->
        <div class="mobile-menu">
            <div class="menu-backdrop"></div>
            <div class="close-btn"><span class="icon flaticon-multiply"></span></div>
            
            <nav class="menu-box">
                <div class="nav-logo">
                	<?php if( manzil_logo( $logo_type, $image_logo, $logo_dimension, $logo_text, $logo_typography ) ):?>
					<?php echo manzil_logo( $logo_type, $image_logo, $logo_dimension, $logo_text, $logo_typography ); ?>
                	<?php else :?>
                        <img src="<?php echo esc_url( get_template_directory_uri(). '/assets/images/logo.png' );?>">
                    <?php endif;?>
                </div>
                <div class="menu-outer">
					<!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
				</div>
            </nav>
        </div><!-- End Mobile Menu -->
    
    </header>
    <!-- End Main Header -->